/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.set.mutable.primitive;

import net.jcip.annotations.NotThreadSafe;
import org.eclipse.collections.api.BooleanIterable;
import org.eclipse.collections.api.block.function.primitive.BooleanToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.BooleanPredicate;
import org.eclipse.collections.api.collection.primitive.MutableBooleanCollection;
import org.eclipse.collections.api.set.MutableSet;
import org.eclipse.collections.api.set.primitive.BooleanSet;
import org.eclipse.collections.api.set.primitive.ImmutableBooleanSet;
import org.eclipse.collections.api.set.primitive.MutableBooleanSet;
import org.eclipse.collections.impl.collection.mutable.primitive.AbstractUnmodifiableBooleanCollection;
import org.eclipse.collections.impl.set.mutable.primitive.SynchronizedBooleanSet;

@NotThreadSafe
public final class UnmodifiableBooleanSet
extends AbstractUnmodifiableBooleanCollection
implements MutableBooleanSet {
    private static final long serialVersionUID = 1L;

    public UnmodifiableBooleanSet(MutableBooleanSet set) {
        super((MutableBooleanCollection)set);
    }

    public static UnmodifiableBooleanSet of(MutableBooleanSet set) {
        if (set == null) {
            throw new IllegalArgumentException("cannot create an UnmodifiableBooleanSet for null");
        }
        return new UnmodifiableBooleanSet(set);
    }

    private MutableBooleanSet getMutableBooleanSet() {
        return (MutableBooleanSet)this.getBooleanCollection();
    }

    @Override
    public UnmodifiableBooleanSet with(boolean element) {
        throw new UnsupportedOperationException("Cannot call with() on " + this.getClass().getSimpleName());
    }

    @Override
    public UnmodifiableBooleanSet without(boolean element) {
        throw new UnsupportedOperationException("Cannot call without() on " + this.getClass().getSimpleName());
    }

    @Override
    public UnmodifiableBooleanSet withAll(BooleanIterable elements) {
        throw new UnsupportedOperationException("Cannot call withAll() on " + this.getClass().getSimpleName());
    }

    @Override
    public UnmodifiableBooleanSet withoutAll(BooleanIterable elements) {
        throw new UnsupportedOperationException("Cannot call withoutAll() on " + this.getClass().getSimpleName());
    }

    public MutableBooleanSet select(BooleanPredicate predicate) {
        return this.getMutableBooleanSet().select(predicate);
    }

    public MutableBooleanSet reject(BooleanPredicate predicate) {
        return this.getMutableBooleanSet().reject(predicate);
    }

    public <V> MutableSet<V> collect(BooleanToObjectFunction<? extends V> function) {
        return this.getMutableBooleanSet().collect(function);
    }

    public boolean equals(Object otherSet) {
        return this.getMutableBooleanSet().equals(otherSet);
    }

    public int hashCode() {
        return this.getMutableBooleanSet().hashCode();
    }

    public MutableBooleanSet asUnmodifiable() {
        return this;
    }

    public MutableBooleanSet asSynchronized() {
        return new SynchronizedBooleanSet(this);
    }

    public BooleanSet freeze() {
        return this.getMutableBooleanSet().freeze();
    }

    public ImmutableBooleanSet toImmutable() {
        return this.getMutableBooleanSet().toImmutable();
    }
}

