/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.bag.mutable.primitive;

import net.jcip.annotations.GuardedBy;
import net.jcip.annotations.ThreadSafe;
import org.eclipse.collections.api.BooleanIterable;
import org.eclipse.collections.api.LazyBooleanIterable;
import org.eclipse.collections.api.bag.MutableBag;
import org.eclipse.collections.api.bag.primitive.ImmutableBooleanBag;
import org.eclipse.collections.api.bag.primitive.MutableBooleanBag;
import org.eclipse.collections.api.block.function.primitive.BooleanToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.BooleanPredicate;
import org.eclipse.collections.api.block.predicate.primitive.IntPredicate;
import org.eclipse.collections.api.block.procedure.primitive.BooleanIntProcedure;
import org.eclipse.collections.api.collection.primitive.MutableBooleanCollection;
import org.eclipse.collections.api.list.MutableList;
import org.eclipse.collections.api.tuple.primitive.BooleanIntPair;
import org.eclipse.collections.impl.bag.mutable.primitive.UnmodifiableBooleanBag;
import org.eclipse.collections.impl.collection.mutable.primitive.AbstractSynchronizedBooleanCollection;
import org.eclipse.collections.impl.factory.primitive.BooleanBags;
import org.eclipse.collections.impl.lazy.primitive.LazyBooleanIterableAdapter;

@ThreadSafe
public final class SynchronizedBooleanBag
extends AbstractSynchronizedBooleanCollection
implements MutableBooleanBag {
    private static final long serialVersionUID = 1L;

    public SynchronizedBooleanBag(MutableBooleanBag bag) {
        super((MutableBooleanCollection)bag);
    }

    public SynchronizedBooleanBag(MutableBooleanBag bag, Object newLock) {
        super((MutableBooleanCollection)bag, newLock);
    }

    @GuardedBy(value="getLock()")
    private MutableBooleanBag getMutableBooleanBag() {
        return (MutableBooleanBag)this.getBooleanCollection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SynchronizedBooleanBag with(boolean element) {
        Object object = this.getLock();
        synchronized (object) {
            this.getMutableBooleanBag().add(element);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SynchronizedBooleanBag without(boolean element) {
        Object object = this.getLock();
        synchronized (object) {
            this.getMutableBooleanBag().remove(element);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SynchronizedBooleanBag withAll(BooleanIterable elements) {
        Object object = this.getLock();
        synchronized (object) {
            this.getMutableBooleanBag().addAll(elements.toArray());
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SynchronizedBooleanBag withoutAll(BooleanIterable elements) {
        Object object = this.getLock();
        synchronized (object) {
            this.getMutableBooleanBag().removeAll(elements);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addOccurrences(boolean item, int occurrences) {
        Object object = this.getLock();
        synchronized (object) {
            this.getMutableBooleanBag().addOccurrences(item, occurrences);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeOccurrences(boolean item, int occurrences) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableBooleanBag().removeOccurrences(item, occurrences);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int sizeDistinct() {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableBooleanBag().sizeDistinct();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int occurrencesOf(boolean item) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableBooleanBag().occurrencesOf(item);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forEachWithOccurrences(BooleanIntProcedure procedure) {
        Object object = this.getLock();
        synchronized (object) {
            this.getMutableBooleanBag().forEachWithOccurrences(procedure);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableBooleanBag select(BooleanPredicate predicate) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableBooleanBag().select(predicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableBooleanBag selectByOccurrences(IntPredicate predicate) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableBooleanBag().selectByOccurrences(predicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableList<BooleanIntPair> topOccurrences(int count) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableBooleanBag().topOccurrences(count);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableList<BooleanIntPair> bottomOccurrences(int count) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableBooleanBag().bottomOccurrences(count);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableBooleanBag reject(BooleanPredicate predicate) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableBooleanBag().reject(predicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <V> MutableBag<V> collect(BooleanToObjectFunction<? extends V> function) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableBooleanBag().collect(function);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean equals(Object otherBag) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableBooleanBag().equals(otherBag);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int hashCode() {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableBooleanBag().hashCode();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LazyBooleanIterable asLazy() {
        Object object = this.getLock();
        synchronized (object) {
            return new LazyBooleanIterableAdapter((BooleanIterable)this);
        }
    }

    public MutableBooleanBag asUnmodifiable() {
        return new UnmodifiableBooleanBag(this);
    }

    public MutableBooleanBag asSynchronized() {
        return this;
    }

    public ImmutableBooleanBag toImmutable() {
        return BooleanBags.immutable.withAll((BooleanIterable)this);
    }
}

