/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.collection.mutable.primitive;

import java.io.Serializable;
import org.eclipse.collections.api.LazyShortIterable;
import org.eclipse.collections.api.RichIterable;
import org.eclipse.collections.api.ShortIterable;
import org.eclipse.collections.api.bag.primitive.MutableShortBag;
import org.eclipse.collections.api.block.function.primitive.LongShortToLongFunction;
import org.eclipse.collections.api.block.function.primitive.ObjectShortToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.ShortToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.ShortPredicate;
import org.eclipse.collections.api.block.procedure.primitive.ShortProcedure;
import org.eclipse.collections.api.collection.MutableCollection;
import org.eclipse.collections.api.collection.primitive.ImmutableShortCollection;
import org.eclipse.collections.api.collection.primitive.MutableShortCollection;
import org.eclipse.collections.api.iterator.MutableShortIterator;
import org.eclipse.collections.api.iterator.ShortIterator;
import org.eclipse.collections.api.list.primitive.MutableShortList;
import org.eclipse.collections.api.set.primitive.MutableShortSet;
import org.eclipse.collections.impl.collection.mutable.primitive.SynchronizedShortCollection;
import org.eclipse.collections.impl.iterator.UnmodifiableShortIterator;
import org.eclipse.collections.impl.lazy.primitive.LazyShortIterableAdapter;

public abstract class AbstractUnmodifiableShortCollection
implements MutableShortCollection,
Serializable {
    private static final long serialVersionUID = 1L;
    private final MutableShortCollection collection;

    protected AbstractUnmodifiableShortCollection(MutableShortCollection collection) {
        if (collection == null) {
            throw new IllegalArgumentException("Cannot create a AbstractUnmodifiableShortCollection on a null collection");
        }
        this.collection = collection;
    }

    protected MutableShortCollection getShortCollection() {
        return this.collection;
    }

    public int size() {
        return this.collection.size();
    }

    public boolean isEmpty() {
        return this.collection.isEmpty();
    }

    public boolean notEmpty() {
        return this.collection.notEmpty();
    }

    public void clear() {
        throw new UnsupportedOperationException("Cannot call clear() on " + this.getClass().getSimpleName());
    }

    public boolean contains(short value) {
        return this.collection.contains(value);
    }

    public boolean containsAll(short ... source) {
        return this.collection.containsAll(source);
    }

    public boolean containsAll(ShortIterable source) {
        return this.collection.containsAll(source);
    }

    public boolean containsAny(short ... source) {
        return this.collection.containsAny(source);
    }

    public boolean containsAny(ShortIterable source) {
        return this.collection.containsAny(source);
    }

    public boolean containsNone(short ... source) {
        return this.collection.containsNone(source);
    }

    public boolean containsNone(ShortIterable source) {
        return this.collection.containsNone(source);
    }

    public boolean add(short newItem) {
        throw new UnsupportedOperationException("Cannot call add() on " + this.getClass().getSimpleName());
    }

    public boolean addAll(short ... source) {
        throw new UnsupportedOperationException("Cannot call addAll() on " + this.getClass().getSimpleName());
    }

    public boolean addAll(ShortIterable source) {
        throw new UnsupportedOperationException("Cannot call addAll() on " + this.getClass().getSimpleName());
    }

    public boolean remove(short value) {
        throw new UnsupportedOperationException("Cannot call remove() on " + this.getClass().getSimpleName());
    }

    public boolean removeIf(ShortPredicate predicate) {
        throw new UnsupportedOperationException("Cannot call removeIf() on " + this.getClass().getSimpleName());
    }

    public boolean removeAll(ShortIterable source) {
        throw new UnsupportedOperationException("Cannot call removeAll() on " + this.getClass().getSimpleName());
    }

    public boolean removeAll(short ... source) {
        throw new UnsupportedOperationException("Cannot call removeAll() on " + this.getClass().getSimpleName());
    }

    public boolean retainAll(ShortIterable source) {
        throw new UnsupportedOperationException("Cannot call retainAll() on " + this.getClass().getSimpleName());
    }

    public boolean retainAll(short ... source) {
        throw new UnsupportedOperationException("Cannot call retainAll() on " + this.getClass().getSimpleName());
    }

    public MutableShortIterator shortIterator() {
        return new UnmodifiableShortIterator((ShortIterator)this.collection.shortIterator());
    }

    public void forEach(ShortProcedure procedure) {
        this.each(procedure);
    }

    public void each(ShortProcedure procedure) {
        this.collection.forEach(procedure);
    }

    public int count(ShortPredicate predicate) {
        return this.collection.count(predicate);
    }

    public boolean anySatisfy(ShortPredicate predicate) {
        return this.collection.anySatisfy(predicate);
    }

    public boolean allSatisfy(ShortPredicate predicate) {
        return this.collection.allSatisfy(predicate);
    }

    public boolean noneSatisfy(ShortPredicate predicate) {
        return this.collection.noneSatisfy(predicate);
    }

    public MutableShortCollection select(ShortPredicate predicate) {
        return this.collection.select(predicate);
    }

    public MutableShortCollection reject(ShortPredicate predicate) {
        return this.collection.reject(predicate);
    }

    public <V> MutableCollection<V> collect(ShortToObjectFunction<? extends V> function) {
        return this.collection.collect(function);
    }

    public MutableShortCollection with(short element) {
        throw new UnsupportedOperationException("Cannot call with() on " + this.getClass().getSimpleName());
    }

    public MutableShortCollection without(short element) {
        throw new UnsupportedOperationException("Cannot call without() on " + this.getClass().getSimpleName());
    }

    public MutableShortCollection withAll(ShortIterable elements) {
        throw new UnsupportedOperationException("Cannot call withAll() on " + this.getClass().getSimpleName());
    }

    public MutableShortCollection withoutAll(ShortIterable elements) {
        throw new UnsupportedOperationException("Cannot call withoutAll() on " + this.getClass().getSimpleName());
    }

    public MutableShortCollection asUnmodifiable() {
        return this;
    }

    public MutableShortCollection asSynchronized() {
        return new SynchronizedShortCollection(this);
    }

    public ImmutableShortCollection toImmutable() {
        return this.collection.toImmutable();
    }

    public LazyShortIterable asLazy() {
        return new LazyShortIterableAdapter((ShortIterable)this);
    }

    public short detectIfNone(ShortPredicate predicate, short ifNone) {
        return this.collection.detectIfNone(predicate, ifNone);
    }

    public long sum() {
        return this.collection.sum();
    }

    public short max() {
        return this.collection.max();
    }

    public short min() {
        return this.collection.min();
    }

    public short minIfEmpty(short defaultValue) {
        return this.collection.minIfEmpty(defaultValue);
    }

    public short maxIfEmpty(short defaultValue) {
        return this.collection.maxIfEmpty(defaultValue);
    }

    public double average() {
        return this.collection.average();
    }

    public double median() {
        return this.collection.median();
    }

    public MutableShortList toSortedList() {
        return this.collection.toSortedList();
    }

    public short[] toSortedArray() {
        return this.collection.toSortedArray();
    }

    public short[] toArray() {
        return this.collection.toArray();
    }

    public short[] toArray(short[] target) {
        return this.collection.toArray(target);
    }

    public String toString() {
        return this.collection.toString();
    }

    public String makeString() {
        return this.collection.makeString();
    }

    public String makeString(String separator) {
        return this.collection.makeString(separator);
    }

    public String makeString(String start, String separator, String end) {
        return this.collection.makeString(start, separator, end);
    }

    public void appendString(Appendable appendable) {
        this.collection.appendString(appendable);
    }

    public void appendString(Appendable appendable, String separator) {
        this.collection.appendString(appendable, separator);
    }

    public void appendString(Appendable appendable, String start, String separator, String end) {
        this.collection.appendString(appendable, start, separator, end);
    }

    public MutableShortList toList() {
        return this.collection.toList();
    }

    public MutableShortSet toSet() {
        return this.collection.toSet();
    }

    public MutableShortBag toBag() {
        return this.collection.toBag();
    }

    public <T> T injectInto(T injectedValue, ObjectShortToObjectFunction<? super T, ? extends T> function) {
        return (T)this.collection.injectInto(injectedValue, function);
    }

    public long reduce(LongShortToLongFunction accumulator) {
        return this.collection.reduce(accumulator);
    }

    public long reduceIfEmpty(LongShortToLongFunction accumulator, long defaultValue) {
        return this.collection.reduceIfEmpty(accumulator, defaultValue);
    }

    public RichIterable<ShortIterable> chunk(int size) {
        return this.collection.chunk(size);
    }
}

