/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.list.mutable.primitive;

import org.eclipse.collections.api.ShortIterable;
import org.eclipse.collections.api.factory.list.primitive.MutableShortListFactory;
import org.eclipse.collections.api.list.primitive.MutableShortList;
import org.eclipse.collections.impl.factory.primitive.ShortLists;
import org.eclipse.collections.impl.list.mutable.primitive.ShortArrayList;
import org.eclipse.collections.impl.utility.Iterate;

public enum MutableShortListFactoryImpl implements MutableShortListFactory
{
    INSTANCE;


    public MutableShortList empty() {
        return new ShortArrayList();
    }

    public MutableShortList of() {
        return this.empty();
    }

    public MutableShortList with() {
        return this.empty();
    }

    public MutableShortList of(short ... items) {
        return this.with(items);
    }

    public MutableShortList with(short ... items) {
        if (items == null || items.length == 0) {
            return this.with();
        }
        return ShortArrayList.newListWith(items);
    }

    public MutableShortList ofAll(ShortIterable items) {
        return this.withAll(items);
    }

    public MutableShortList withAll(ShortIterable items) {
        return ShortArrayList.newList(items);
    }

    public MutableShortList ofAll(Iterable<Short> iterable) {
        return this.withAll(iterable);
    }

    public MutableShortList withAll(Iterable<Short> iterable) {
        return Iterate.collectShort(iterable, Short::shortValue, ShortLists.mutable.empty());
    }
}

