/*
 * Decompiled with CFR 0.152.
 */
package com.sun.mail.util;

import jakarta.mail.Session;
import java.util.Properties;
import java.util.concurrent.ScheduledExecutorService;

public class PropUtil {
    private PropUtil() {
    }

    public static int getIntProperty(Properties props, String name, int def) {
        return PropUtil.getInt(PropUtil.getProp(props, name), def);
    }

    public static boolean getBooleanProperty(Properties props, String name, boolean def) {
        return PropUtil.getBoolean(PropUtil.getProp(props, name), def);
    }

    public static ScheduledExecutorService getScheduledExecutorServiceProperty(Properties props, String name) {
        return PropUtil.getScheduledExecutorService(PropUtil.getProp(props, name));
    }

    @Deprecated
    public static int getIntSessionProperty(Session session, String name, int def) {
        return PropUtil.getInt(PropUtil.getProp(session.getProperties(), name), def);
    }

    @Deprecated
    public static boolean getBooleanSessionProperty(Session session, String name, boolean def) {
        return PropUtil.getBoolean(PropUtil.getProp(session.getProperties(), name), def);
    }

    public static boolean getBooleanSystemProperty(String name, boolean def) {
        try {
            return PropUtil.getBoolean(PropUtil.getProp(System.getProperties(), name), def);
        }
        catch (SecurityException securityException) {
            try {
                String value = System.getProperty(name);
                if (value == null) {
                    return def;
                }
                if (def) {
                    return !value.equalsIgnoreCase("false");
                }
                return value.equalsIgnoreCase("true");
            }
            catch (SecurityException sex) {
                return def;
            }
        }
    }

    private static Object getProp(Properties props, String name) {
        Object val = props.get(name);
        if (val != null) {
            return val;
        }
        return props.getProperty(name);
    }

    private static int getInt(Object value, int def) {
        if (value == null) {
            return def;
        }
        if (value instanceof String) {
            try {
                String s = (String)value;
                if (s.startsWith("0x")) {
                    return Integer.parseInt(s.substring(2), 16);
                }
                return Integer.parseInt(s);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (value instanceof Integer) {
            return (Integer)value;
        }
        return def;
    }

    private static ScheduledExecutorService getScheduledExecutorService(Object value) {
        return (ScheduledExecutorService)value;
    }

    private static boolean getBoolean(Object value, boolean def) {
        if (value == null) {
            return def;
        }
        if (value instanceof String) {
            if (def) {
                return !((String)value).equalsIgnoreCase("false");
            }
            return ((String)value).equalsIgnoreCase("true");
        }
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        return def;
    }
}

