/*
 * Decompiled with CFR 0.152.
 */
package org.fest.assertions;

import org.fest.assertions.ErrorMessages;
import org.fest.assertions.GenericAssert;
import org.fest.assertions.NumberAssert;
import org.fest.util.VisibleForTesting;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ShortAssert
extends GenericAssert<ShortAssert, Short>
implements NumberAssert {
    private static final short ZERO = 0;

    @VisibleForTesting
    ShortAssert(int actual) {
        this((short)actual);
    }

    protected ShortAssert(short actual) {
        super(ShortAssert.class, actual);
    }

    protected ShortAssert(Short actual) {
        super(ShortAssert.class, actual);
    }

    @Override
    public ShortAssert isEqualTo(short expected) {
        return (ShortAssert)this.isEqualTo(Short.valueOf(expected));
    }

    @Override
    public ShortAssert isNotEqualTo(short other) {
        return (ShortAssert)this.isNotEqualTo(Short.valueOf(other));
    }

    public ShortAssert isGreaterThan(short other) {
        if ((Short)this.actual > other) {
            return this;
        }
        this.failIfCustomMessageIsSet();
        throw this.failure(ErrorMessages.unexpectedLessThanOrEqualTo(this.actual, other));
    }

    public ShortAssert isLessThan(short other) {
        if ((Short)this.actual < other) {
            return this;
        }
        this.failIfCustomMessageIsSet();
        throw this.failure(ErrorMessages.unexpectedGreaterThanOrEqualTo(this.actual, other));
    }

    public ShortAssert isGreaterThanOrEqualTo(short other) {
        if ((Short)this.actual >= other) {
            return this;
        }
        this.failIfCustomMessageIsSet();
        throw this.failure(ErrorMessages.unexpectedLessThan(this.actual, other));
    }

    public ShortAssert isLessThanOrEqualTo(short other) {
        if ((Short)this.actual <= other) {
            return this;
        }
        this.failIfCustomMessageIsSet();
        throw this.failure(ErrorMessages.unexpectedGreaterThan(this.actual, other));
    }

    @Override
    public ShortAssert isZero() {
        return this.isEqualTo((short)0);
    }

    @Override
    public ShortAssert isPositive() {
        return this.isGreaterThan((short)0);
    }

    @Override
    public ShortAssert isNegative() {
        return this.isLessThan((short)0);
    }
}

