/*
 * Decompiled with CFR 0.152.
 */
package org.fest.assertions;

import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import org.fest.assertions.ErrorMessages;
import org.fest.assertions.Fail;
import org.fest.assertions.Formatting;
import org.fest.assertions.GenericAssert;
import org.fest.assertions.ImageReader;
import org.fest.assertions.RGBColor;
import org.fest.assertions.Threshold;
import org.fest.util.Objects;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImageAssert
extends GenericAssert<ImageAssert, BufferedImage> {
    private static final Threshold ZERO_THRESHOLD = Threshold.threshold(0);
    private static ImageReader imageReader = new ImageReader();

    public static BufferedImage read(String imageFilePath) throws IOException {
        if (imageFilePath == null) {
            throw new NullPointerException("The path of the image to read should not be null");
        }
        File imageFile = new File(imageFilePath);
        if (!imageFile.isFile()) {
            throw new IllegalArgumentException(Formatting.format("The path <%s> does not belong to a file", imageFilePath));
        }
        return imageReader.read(imageFile);
    }

    protected ImageAssert(BufferedImage actual) {
        super(ImageAssert.class, actual);
    }

    @Override
    public ImageAssert isEqualTo(BufferedImage expected) {
        return this.isEqualTo(expected, ZERO_THRESHOLD);
    }

    public ImageAssert isEqualTo(BufferedImage expected, Threshold threshold) {
        if (Objects.areEqual((Object)this.actual, (Object)expected)) {
            return this;
        }
        this.failIfNull(expected);
        this.failIfNotEqual(ImageAssert.sizeOf((BufferedImage)this.actual), ImageAssert.sizeOf(expected));
        this.failIfNotEqualColor(expected, threshold);
        return this;
    }

    private void failIfNull(BufferedImage expected) {
        if (expected != null) {
            return;
        }
        this.failIfCustomMessageIsSet();
        this.fail(ErrorMessages.unexpectedNotEqual(this.actual, null));
    }

    private void failIfNotEqual(Dimension a, Dimension e) {
        if (Objects.areEqual((Object)a, (Object)e)) {
            return;
        }
        this.failIfCustomMessageIsSet();
        this.fail(Formatting.format("image size: expected:<%s> but was:<%s>", e, a));
    }

    private void failIfNotEqualColor(BufferedImage expected, Threshold threshold) {
        int w = ((BufferedImage)this.actual).getWidth();
        int h = ((BufferedImage)this.actual).getHeight();
        for (int x = 0; x < w; ++x) {
            for (int y = 0; y < h; ++y) {
                this.failIfNotEqual(new RGBColor(((BufferedImage)this.actual).getRGB(x, y)), new RGBColor(expected.getRGB(x, y)), threshold, x, y);
            }
        }
    }

    private void failIfNotEqual(RGBColor a, RGBColor e, Threshold threshold, int x, int y) {
        if (a.isEqualTo(e, threshold.value())) {
            return;
        }
        this.failIfCustomMessageIsSet();
        this.fail(String.format("expected:<%s> but was:<%s> at pixel [%d,%d]", a, e, x, y));
    }

    @Override
    public ImageAssert isNotEqualTo(BufferedImage image) {
        if (Objects.areEqual((Object)this.actual, (Object)image)) {
            this.failIfCustomMessageIsSet();
            throw this.failure(ErrorMessages.unexpectedEqual(this.actual, image));
        }
        if (image == null) {
            return this;
        }
        if (Objects.areEqual((Object)ImageAssert.sizeOf((BufferedImage)this.actual), (Object)ImageAssert.sizeOf(image)) && this.hasEqualColor(image)) {
            this.failIfCustomMessageIsSet();
            throw this.failure("images are equal");
        }
        return this;
    }

    private static Dimension sizeOf(BufferedImage image) {
        return new Dimension(image.getWidth(), image.getHeight());
    }

    private boolean hasEqualColor(BufferedImage expected) {
        int w = ((BufferedImage)this.actual).getWidth();
        int h = ((BufferedImage)this.actual).getHeight();
        for (int x = 0; x < w; ++x) {
            for (int y = 0; y < h; ++y) {
                if (((BufferedImage)this.actual).getRGB(x, y) == expected.getRGB(x, y)) continue;
                return false;
            }
        }
        return true;
    }

    public ImageAssert hasSize(Dimension expected) {
        this.isNotNull();
        if (expected == null) {
            throw new NullPointerException(this.formattedErrorMessage("The size to compare to should not be null"));
        }
        Dimension actualDimension = new Dimension(((BufferedImage)this.actual).getWidth(), ((BufferedImage)this.actual).getHeight());
        Fail.failIfNotEqual(this.customErrorMessage(), this.rawDescription(), actualDimension, expected);
        return this;
    }

    static void imageReader(ImageReader newImageReader) {
        imageReader = newImageReader;
    }
}

