/*
 * Decompiled with CFR 0.152.
 */
package org.fest.assertions;

import org.fest.assertions.ErrorMessages;
import org.fest.assertions.Formatting;
import org.fest.assertions.GenericAssert;
import org.fest.assertions.NumberAssert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DoubleAssert
extends GenericAssert<DoubleAssert, Double>
implements NumberAssert {
    private static final double ZERO = 0.0;

    protected DoubleAssert(double actual) {
        super(DoubleAssert.class, actual);
    }

    protected DoubleAssert(Double actual) {
        super(DoubleAssert.class, actual);
    }

    @Override
    public DoubleAssert isEqualTo(double expected) {
        return (DoubleAssert)this.isEqualTo(Double.valueOf(expected));
    }

    @Deprecated
    public DoubleAssert isEqualTo(double expected, Delta delta) {
        return this.isEqualTo(expected, delta.value);
    }

    public DoubleAssert isEqualTo(double expected, org.fest.assertions.Delta delta) {
        return this.isEqualTo(expected, delta.doubleValue());
    }

    private DoubleAssert isEqualTo(double expected, double deltaValue) {
        return this.isEqualTo((Double)expected, deltaValue);
    }

    public DoubleAssert isEqualTo(Double expected, org.fest.assertions.Delta delta) {
        return this.isEqualTo(expected, delta.doubleValue());
    }

    private DoubleAssert isEqualTo(Double expected, double deltaValue) {
        if (this.actual == null || expected == null) {
            return (DoubleAssert)this.isEqualTo(expected);
        }
        if (((Double)this.actual).compareTo(expected) == 0) {
            return this;
        }
        if (Math.abs(expected - (Double)this.actual) <= deltaValue) {
            return this;
        }
        this.failIfCustomMessageIsSet();
        throw this.failure(ErrorMessages.unexpectedNotEqual(this.actual, expected) + Formatting.format(" using delta:<%s>", deltaValue));
    }

    @Override
    public DoubleAssert isNotEqualTo(double other) {
        if (this.compareTo(other) != 0) {
            return this;
        }
        this.failIfCustomMessageIsSet();
        throw this.failure(ErrorMessages.unexpectedEqual(this.actual, other));
    }

    public DoubleAssert isGreaterThan(double other) {
        if (this.compareTo(other) > 0) {
            return this;
        }
        this.failIfCustomMessageIsSet();
        throw this.failure(ErrorMessages.unexpectedLessThanOrEqualTo(this.actual, other));
    }

    public DoubleAssert isLessThan(double other) {
        if (this.compareTo(other) < 0) {
            return this;
        }
        this.failIfCustomMessageIsSet();
        throw this.failure(ErrorMessages.unexpectedGreaterThanOrEqualTo(this.actual, other));
    }

    public DoubleAssert isGreaterThanOrEqualTo(double other) {
        if (this.compareTo(other) >= 0) {
            return this;
        }
        this.failIfCustomMessageIsSet();
        throw this.failure(ErrorMessages.unexpectedLessThan(this.actual, other));
    }

    public DoubleAssert isLessThanOrEqualTo(double other) {
        if (this.compareTo(other) <= 0) {
            return this;
        }
        this.failIfCustomMessageIsSet();
        throw this.failure(ErrorMessages.unexpectedGreaterThan(this.actual, other));
    }

    private int compareTo(double other) {
        return Double.compare((Double)this.actual, other);
    }

    @Override
    public DoubleAssert isZero() {
        return this.isEqualTo(0.0);
    }

    @Override
    public DoubleAssert isPositive() {
        return this.isGreaterThan(0.0);
    }

    @Override
    public DoubleAssert isNegative() {
        return this.isLessThan(0.0);
    }

    public DoubleAssert isNaN() {
        return this.isEqualTo(Double.NaN);
    }

    @Deprecated
    public static Delta delta(double d) {
        return new Delta(d);
    }

    @Deprecated
    public static class Delta {
        final double value;

        private Delta(double value) {
            this.value = value;
        }
    }
}

