/*
 * Decompiled with CFR 0.152.
 */
package org.drools.util;

import java.lang.reflect.Method;
import java.util.Optional;

public class MethodUtils {
    public static Method findMethod(Class<?> clazz, String methodName, Class[] argsType) {
        try {
            return clazz.getMethod(methodName, argsType);
        }
        catch (NoSuchMethodException e) {
            return MethodUtils.getBestCandidate(clazz, argsType, methodName);
        }
    }

    public static Optional<Method> getMethod(Class<?> clazz, String name, Class<?> ... parameterTypes) {
        return Optional.ofNullable(MethodUtils.findMethod(clazz, name, parameterTypes));
    }

    private static Method getBestCandidate(Class clazz, Class[] argsType, String methodName) {
        return MethodUtils.getBestCandidate(clazz, argsType, methodName, clazz.getMethods());
    }

    private static Method getBestCandidate(Class clazz, Class[] argsType, String methodName, Method[] methods) {
        Method bestCandidate = MethodUtils.getBestCandidateMethod(methodName, argsType, methods, null);
        if (bestCandidate != null) {
            return bestCandidate;
        }
        if (clazz.isInterface()) {
            Method[] objMethods = Object.class.getMethods();
            Method[] nMethods = new Method[methods.length + objMethods.length];
            System.arraycopy(methods, 0, nMethods, 0, methods.length);
            System.arraycopy(objMethods, 0, nMethods, methods.length, objMethods.length);
            return MethodUtils.getBestCandidateMethod(methodName, argsType, nMethods, bestCandidate);
        }
        return null;
    }

    private static Method getBestCandidateMethod(String methodName, Class[] argsType, Method[] methods, Method oldBestCandidate) {
        int bestScore = -1;
        Method bestCandidate = oldBestCandidate;
        for (Method method : methods) {
            int score;
            if (!methodName.equals(method.getName())) continue;
            Class<?>[] parameterTypes = method.getParameterTypes();
            if (parameterTypes.length == 0 && argsType.length == 0) {
                if (bestCandidate != null && !MethodUtils.isMoreSpecialized(method, bestCandidate)) continue;
                bestCandidate = method;
                continue;
            }
            boolean isVarArgs = method.isVarArgs();
            if (MethodUtils.isArgsNumberNotCompatible(argsType, parameterTypes, isVarArgs) || (score = MethodUtils.getMethodScore(argsType, parameterTypes, isVarArgs)) == 0) continue;
            if (score > bestScore) {
                bestCandidate = method;
                bestScore = score;
                continue;
            }
            if (score != bestScore || !MethodUtils.isMoreSpecialized(method, bestCandidate) || isVarArgs) continue;
            bestCandidate = method;
        }
        return bestCandidate;
    }

    private static boolean isArgsNumberNotCompatible(Class[] arguments, Class<?>[] parameterTypes, boolean isVarArgs) {
        return isVarArgs && parameterTypes.length - 1 > arguments.length || !isVarArgs && parameterTypes.length != arguments.length;
    }

    private static boolean isMoreSpecialized(Method newCandidate, Method oldCandidate) {
        return oldCandidate.getReturnType().isAssignableFrom(newCandidate.getReturnType()) && oldCandidate.getDeclaringClass().isAssignableFrom(newCandidate.getDeclaringClass());
    }

    private static int getMethodScore(Class[] arguments, Class<?>[] parameterTypes, boolean varArgs) {
        int score = 0;
        for (int i = 0; i != arguments.length; ++i) {
            Class<?> actualParamType = varArgs && i >= parameterTypes.length - 1 ? parameterTypes[parameterTypes.length - 1].getComponentType() : parameterTypes[i];
            if (arguments[i] == null) {
                if (!actualParamType.isPrimitive()) {
                    score += 7;
                    continue;
                }
                score = 0;
                break;
            }
            if (actualParamType == arguments[i]) {
                score += 8;
                continue;
            }
            if (actualParamType.isPrimitive() && MethodUtils.boxPrimitive(actualParamType) == arguments[i]) {
                score += 7;
                continue;
            }
            if (arguments[i].isPrimitive() && MethodUtils.unboxPrimitive(arguments[i]) == actualParamType) {
                score += 7;
                continue;
            }
            if (actualParamType.isAssignableFrom(arguments[i])) {
                score += 6;
                continue;
            }
            if (MethodUtils.isPrimitiveSubtype(arguments[i], actualParamType)) {
                score += 5;
                continue;
            }
            if (MethodUtils.isNumericallyCoercible(arguments[i], actualParamType)) {
                score += 4;
                continue;
            }
            if (MethodUtils.boxPrimitive(actualParamType).isAssignableFrom(MethodUtils.boxPrimitive(arguments[i])) && Object.class != arguments[i]) {
                score += 3 + MethodUtils.scoreInterface(actualParamType, arguments[i]);
                continue;
            }
            if (MethodUtils.canConvert(actualParamType, arguments[i])) {
                if (actualParamType.isArray() && arguments[i].isArray()) {
                    ++score;
                } else if (actualParamType == Character.TYPE && arguments[i] == String.class) {
                    ++score;
                }
                ++score;
                continue;
            }
            if (actualParamType == Object.class || arguments[i] == NullType.class) {
                ++score;
                continue;
            }
            score = 0;
            break;
        }
        if (score == 0 && varArgs && parameterTypes.length - 1 == arguments.length) {
            score += 3;
        }
        return score;
    }

    private static boolean canConvert(Class toType, Class convertFrom) {
        return MethodUtils.isAssignableFrom(toType, convertFrom) || toType.isArray() && MethodUtils.canConvert(toType.getComponentType(), convertFrom);
    }

    private static int scoreInterface(Class<?> parm, Class<?> arg) {
        Class<?>[] iface;
        if (parm.isInterface() && (iface = arg.getInterfaces()) != null) {
            for (Class<?> c : iface) {
                if (c == parm) {
                    return 1;
                }
                if (!parm.isAssignableFrom(c)) continue;
                return MethodUtils.scoreInterface(parm, arg.getSuperclass());
            }
        }
        return 0;
    }

    private static boolean isPrimitiveSubtype(Class argument, Class<?> actualParamType) {
        if (!actualParamType.isPrimitive()) {
            return false;
        }
        Class primitiveArgument = MethodUtils.unboxPrimitive(argument);
        if (!primitiveArgument.isPrimitive()) {
            return false;
        }
        return actualParamType == Double.TYPE && primitiveArgument == Float.TYPE || actualParamType == Double.TYPE && primitiveArgument == Integer.TYPE || actualParamType == Float.TYPE && primitiveArgument == Long.TYPE || actualParamType == Long.TYPE && primitiveArgument == Integer.TYPE || actualParamType == Integer.TYPE && primitiveArgument == Character.TYPE || actualParamType == Integer.TYPE && primitiveArgument == Short.TYPE || actualParamType == Short.TYPE && primitiveArgument == Byte.TYPE;
    }

    private static boolean isNumericallyCoercible(Class target, Class parameterMethod) {
        Class<?> boxedTarget;
        Class<?> clazz = boxedTarget = target.isPrimitive() ? MethodUtils.boxPrimitive(target) : target;
        if (boxedTarget != null && Number.class.isAssignableFrom(target) && (boxedTarget = parameterMethod.isPrimitive() ? MethodUtils.boxPrimitive(parameterMethod) : parameterMethod) != null) {
            return Number.class.isAssignableFrom(boxedTarget);
        }
        return false;
    }

    public static Class<?> boxPrimitive(Class cls) {
        if (cls == Integer.TYPE || cls == Integer.class) {
            return Integer.class;
        }
        if (cls == int[].class || cls == Integer[].class) {
            return Integer[].class;
        }
        if (cls == Character.TYPE || cls == Character.class) {
            return Character.class;
        }
        if (cls == char[].class || cls == Character[].class) {
            return Character[].class;
        }
        if (cls == Long.TYPE || cls == Long.class) {
            return Long.class;
        }
        if (cls == long[].class || cls == Long[].class) {
            return Long[].class;
        }
        if (cls == Short.TYPE || cls == Short.class) {
            return Short.class;
        }
        if (cls == short[].class || cls == Short[].class) {
            return Short[].class;
        }
        if (cls == Double.TYPE || cls == Double.class) {
            return Double.class;
        }
        if (cls == double[].class || cls == Double[].class) {
            return Double[].class;
        }
        if (cls == Float.TYPE || cls == Float.class) {
            return Float.class;
        }
        if (cls == float[].class || cls == Float[].class) {
            return Float[].class;
        }
        if (cls == Boolean.TYPE || cls == Boolean.class) {
            return Boolean.class;
        }
        if (cls == boolean[].class || cls == Boolean[].class) {
            return Boolean[].class;
        }
        if (cls == Byte.TYPE || cls == Byte.class) {
            return Byte.class;
        }
        if (cls == byte[].class || cls == Byte[].class) {
            return Byte[].class;
        }
        return cls;
    }

    public static Class unboxPrimitive(Class cls) {
        if (cls == Integer.class || cls == Integer.TYPE) {
            return Integer.TYPE;
        }
        if (cls == Integer[].class || cls == int[].class) {
            return int[].class;
        }
        if (cls == Long.class || cls == Long.TYPE) {
            return Long.TYPE;
        }
        if (cls == Long[].class || cls == long[].class) {
            return long[].class;
        }
        if (cls == Character.class || cls == Character.TYPE) {
            return Character.TYPE;
        }
        if (cls == Character[].class || cls == char[].class) {
            return char[].class;
        }
        if (cls == Short.class || cls == Short.TYPE) {
            return Short.TYPE;
        }
        if (cls == Short[].class || cls == short[].class) {
            return short[].class;
        }
        if (cls == Double.class || cls == Double.TYPE) {
            return Double.TYPE;
        }
        if (cls == Double[].class || cls == double[].class) {
            return double[].class;
        }
        if (cls == Float.class || cls == Float.TYPE) {
            return Float.TYPE;
        }
        if (cls == Float[].class || cls == float[].class) {
            return float[].class;
        }
        if (cls == Boolean.class || cls == Boolean.TYPE) {
            return Boolean.TYPE;
        }
        if (cls == Boolean[].class || cls == boolean[].class) {
            return boolean[].class;
        }
        if (cls == Byte.class || cls == Byte.TYPE) {
            return Byte.TYPE;
        }
        if (cls == Byte[].class || cls == byte[].class) {
            return byte[].class;
        }
        return cls;
    }

    public static boolean isAssignableFrom(Class<?> from, Class<?> to) {
        return from.isAssignableFrom(to) || MethodUtils.areBoxingCompatible(from, to);
    }

    public static boolean areBoxingCompatible(Class<?> c1, Class<?> c2) {
        return c1.isPrimitive() ? MethodUtils.isPrimitiveOf(c2, c1) : c2.isPrimitive() && MethodUtils.isPrimitiveOf(c1, c2);
    }

    private static boolean isPrimitiveOf(Class<?> boxed, Class<?> primitive) {
        if (primitive == Integer.TYPE) {
            return boxed == Integer.class;
        }
        if (primitive == Long.TYPE) {
            return boxed == Long.class;
        }
        if (primitive == Double.TYPE) {
            return boxed == Double.class;
        }
        if (primitive == Float.TYPE) {
            return boxed == Float.class;
        }
        if (primitive == Short.TYPE) {
            return boxed == Short.class;
        }
        if (primitive == Byte.TYPE) {
            return boxed == Byte.class;
        }
        if (primitive == Character.TYPE) {
            return boxed == Character.class;
        }
        if (primitive == Boolean.TYPE) {
            return boxed == Boolean.class;
        }
        return false;
    }

    public static boolean isOverride(Method oldMethod, Method newMethod) {
        return oldMethod.getName().equals(newMethod.getName()) && !oldMethod.getDeclaringClass().equals(newMethod.getDeclaringClass()) && oldMethod.getDeclaringClass().isAssignableFrom(newMethod.getDeclaringClass());
    }

    public static interface NullType {
    }
}

