/*
 * Decompiled with CFR 0.152.
 */
package org.drools.util;

import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.drools.util.StringUtils;

public interface TypeResolver {
    public static final AcceptAllClassFilter ACCEPT_ALL_CLASS_FILTER = new AcceptAllClassFilter();
    public static final ExcludeAnnotationClassFilter EXCLUDE_ANNOTATION_CLASS_FILTER = new ExcludeAnnotationClassFilter();
    public static final OnlyAnnotationClassFilter ONLY_ANNOTATION_CLASS_FILTER = new OnlyAnnotationClassFilter();

    public Set<String> getImports();

    public void addImport(String var1);

    public void addImplicitImport(String var1);

    public Class<?> resolveType(String var1) throws ClassNotFoundException;

    public Class<?> resolveType(String var1, ClassFilter var2) throws ClassNotFoundException;

    public void registerClass(String var1, Class<?> var2);

    public String getFullTypeName(String var1) throws ClassNotFoundException;

    public ClassLoader getClassLoader();

    default public Type resolveParametrizedType(String typeName) throws ClassNotFoundException {
        int genericsStart = typeName.indexOf(60);
        if (typeName.indexOf(60) < 0) {
            return this.resolveType(typeName);
        }
        String rawName = typeName.substring(0, genericsStart).trim();
        Class<?> rawType = this.resolveType(rawName);
        String typeArguments = typeName.substring(genericsStart + 1, typeName.lastIndexOf(62)).trim();
        List<String> args = StringUtils.splitArgumentsList(typeArguments);
        Type[] types = new Type[args.size()];
        for (int i = 0; i < types.length; ++i) {
            try {
                types[i] = this.resolveParametrizedType(args.get(i));
                continue;
            }
            catch (ClassNotFoundException cnfe) {
                return rawType;
            }
        }
        return new ParsedParameterizedType(rawType, types);
    }

    public static class ParsedParameterizedType
    implements ParameterizedType {
        private final Type rawType;
        private final Type[] typeArguments;

        public ParsedParameterizedType(Type rawType, Type[] typeArguments) {
            this.rawType = rawType;
            this.typeArguments = typeArguments;
        }

        @Override
        public Type[] getActualTypeArguments() {
            return this.typeArguments;
        }

        @Override
        public Type getRawType() {
            return this.rawType;
        }

        @Override
        public Type getOwnerType() {
            return null;
        }

        public String toString() {
            String argsString = Stream.of(this.typeArguments).map(this::getCanonicalTypeName).collect(Collectors.joining(", "));
            return this.getCanonicalTypeName(this.rawType) + "<" + argsString + ">";
        }

        private String getCanonicalTypeName(Type type) {
            return type instanceof Class ? ((Class)type).getCanonicalName() : type.getTypeName();
        }
    }

    public static class AcceptAllClassFilter
    implements ClassFilter {
        @Override
        public boolean accept(Class<?> clazz) {
            return true;
        }
    }

    public static class ExcludeAnnotationClassFilter
    implements ClassFilter {
        @Override
        public boolean accept(Class<?> clazz) {
            return !Annotation.class.isAssignableFrom(clazz);
        }
    }

    public static class OnlyAnnotationClassFilter
    implements ClassFilter {
        @Override
        public boolean accept(Class<?> clazz) {
            return Annotation.class.isAssignableFrom(clazz);
        }
    }

    public static interface ClassFilter {
        public boolean accept(Class<?> var1);
    }
}

