/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.evaluators;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.drools.base.base.ValueResolver;
import org.drools.base.base.ValueType;
import org.drools.base.rule.accessor.Evaluator;
import org.drools.base.rule.accessor.FieldValue;
import org.drools.base.rule.accessor.ReadAccessor;
import org.drools.base.time.Interval;
import org.drools.base.util.TimeIntervalParser;
import org.drools.compiler.rule.builder.EvaluatorDefinition;
import org.drools.core.common.DefaultEventHandle;
import org.drools.drl.parser.impl.Operator;
import org.drools.mvel.evaluators.BaseEvaluator;
import org.drools.mvel.evaluators.VariableRestriction;
import org.kie.api.runtime.rule.FactHandle;

public class CoincidesEvaluatorDefinition
implements EvaluatorDefinition {
    protected static final String coincidesOp = Operator.BuiltInOperator.COINCIDES.getSymbol();
    public static final Operator COINCIDES = Operator.determineOperator((String)coincidesOp, (boolean)false);
    public static final Operator COINCIDES_NOT = Operator.determineOperator((String)coincidesOp, (boolean)true);
    private static final String[] SUPPORTED_IDS = new String[]{coincidesOp};
    private Map<String, CoincidesEvaluator> cache = Collections.emptyMap();

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.cache = (Map)in.readObject();
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.cache);
    }

    public Evaluator getEvaluator(ValueType type, Operator operator) {
        return this.getEvaluator(type, operator.getOperatorString(), operator.isNegated(), null);
    }

    public Evaluator getEvaluator(ValueType type, Operator operator, String parameterText) {
        return this.getEvaluator(type, operator.getOperatorString(), operator.isNegated(), parameterText);
    }

    public Evaluator getEvaluator(ValueType type, String operatorId, boolean isNegated, String parameterText) {
        return this.getEvaluator(type, operatorId, isNegated, parameterText, EvaluatorDefinition.Target.HANDLE, EvaluatorDefinition.Target.HANDLE);
    }

    public Evaluator getEvaluator(ValueType type, String operatorId, boolean isNegated, String parameterText, EvaluatorDefinition.Target left, EvaluatorDefinition.Target right) {
        String key;
        CoincidesEvaluator eval;
        if (this.cache == Collections.EMPTY_MAP) {
            this.cache = new HashMap<String, CoincidesEvaluator>();
        }
        if ((eval = this.cache.get(key = left + ":" + right + ":" + isNegated + ":" + parameterText)) == null) {
            long[] params = TimeIntervalParser.parse((String)parameterText);
            eval = new CoincidesEvaluator(type, isNegated, params, parameterText, left == EvaluatorDefinition.Target.FACT, right == EvaluatorDefinition.Target.FACT);
            this.cache.put(key, eval);
        }
        return eval;
    }

    public String[] getEvaluatorIds() {
        return SUPPORTED_IDS;
    }

    public boolean isNegatable() {
        return true;
    }

    public EvaluatorDefinition.Target getTarget() {
        return EvaluatorDefinition.Target.BOTH;
    }

    public boolean supportsType(ValueType type) {
        return true;
    }

    public static class CoincidesEvaluator
    extends BaseEvaluator {
        private static final long serialVersionUID = 510L;
        private long startDev;
        private long endDev;
        private String paramText;
        private boolean unwrapLeft;
        private boolean unwrapRight;

        public CoincidesEvaluator() {
        }

        public CoincidesEvaluator(ValueType type, boolean isNegated, long[] parameters, String paramText, boolean unwrapLeft, boolean unwrapRight) {
            super(type, isNegated ? COINCIDES_NOT : COINCIDES);
            this.paramText = paramText;
            this.unwrapLeft = unwrapLeft;
            this.unwrapRight = unwrapRight;
            this.setParameters(parameters);
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            super.readExternal(in);
            this.startDev = in.readLong();
            this.endDev = in.readLong();
            this.unwrapLeft = in.readBoolean();
            this.unwrapRight = in.readBoolean();
            this.paramText = (String)in.readObject();
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            super.writeExternal(out);
            out.writeLong(this.startDev);
            out.writeLong(this.endDev);
            out.writeBoolean(this.unwrapLeft);
            out.writeBoolean(this.unwrapRight);
            out.writeObject(this.paramText);
        }

        @Override
        public boolean isTemporal() {
            return true;
        }

        @Override
        public Interval getInterval() {
            if (this.getOperator().isNegated()) {
                return new Interval(Long.MIN_VALUE, Long.MAX_VALUE);
            }
            return new Interval(0L, 0L);
        }

        public boolean evaluate(ValueResolver valueResolver, ReadAccessor extractor, FactHandle object1, FieldValue object2) {
            throw new RuntimeException("The 'coincides' operator can only be used to compare one event to another, and never to compare to literal constraints.");
        }

        @Override
        public boolean evaluateCachedRight(ValueResolver valueResolver, VariableRestriction.VariableContextEntry context, FactHandle left) {
            long leftEndTS;
            long leftStartTS;
            if (context.rightNull || context.declaration.getExtractor().isNullValue(valueResolver, left.getObject())) {
                return false;
            }
            long rightStartTS = ((VariableRestriction.TemporalVariableContextEntry)context).startTS;
            long rightEndTS = ((VariableRestriction.TemporalVariableContextEntry)context).endTS;
            if (context.declaration.getExtractor().isSelfReference()) {
                leftStartTS = ((DefaultEventHandle)left).getStartTimestamp();
                leftEndTS = ((DefaultEventHandle)left).getEndTimestamp();
            } else {
                leftEndTS = leftStartTS = context.declaration.getExtractor().getLongValue(valueResolver, left.getObject());
            }
            long distStart = Math.abs(rightStartTS - leftStartTS);
            long distEnd = Math.abs(rightEndTS - leftEndTS);
            return this.getOperator().isNegated() ^ (distStart <= this.startDev && distEnd <= this.endDev);
        }

        @Override
        public boolean evaluateCachedLeft(ValueResolver valueResolver, VariableRestriction.VariableContextEntry context, FactHandle right) {
            long rightEndTS;
            long rightStartTS;
            if (context.leftNull || context.extractor.isNullValue(valueResolver, right.getObject())) {
                return false;
            }
            if (context.extractor.isSelfReference()) {
                rightStartTS = ((DefaultEventHandle)right).getStartTimestamp();
                rightEndTS = ((DefaultEventHandle)right).getEndTimestamp();
            } else {
                rightEndTS = rightStartTS = context.extractor.getLongValue(valueResolver, right.getObject());
            }
            long leftStartTS = ((VariableRestriction.TemporalVariableContextEntry)context).startTS;
            long leftEndTS = ((VariableRestriction.TemporalVariableContextEntry)context).endTS;
            long distStart = Math.abs(rightStartTS - leftStartTS);
            long distEnd = Math.abs(rightEndTS - leftEndTS);
            return this.getOperator().isNegated() ^ (distStart <= this.startDev && distEnd <= this.endDev);
        }

        public boolean evaluate(ValueResolver valueResolver, ReadAccessor extractor1, FactHandle handle1, ReadAccessor extractor2, FactHandle handle2) {
            long leftEndTS;
            long leftStartTS;
            long rightEndTS;
            long rightStartTS;
            if (extractor1.isNullValue(valueResolver, handle1.getObject()) || extractor2.isNullValue(valueResolver, handle2.getObject())) {
                return false;
            }
            if (extractor1.isSelfReference()) {
                rightStartTS = ((DefaultEventHandle)handle1).getStartTimestamp();
                rightEndTS = ((DefaultEventHandle)handle1).getEndTimestamp();
            } else {
                rightEndTS = rightStartTS = extractor1.getLongValue(valueResolver, handle1.getObject());
            }
            if (extractor2.isSelfReference()) {
                leftStartTS = ((DefaultEventHandle)handle2).getStartTimestamp();
                leftEndTS = ((DefaultEventHandle)handle2).getEndTimestamp();
            } else {
                leftEndTS = leftStartTS = extractor2.getLongValue(valueResolver, handle2.getObject());
            }
            long distStart = Math.abs(rightStartTS - leftStartTS);
            long distEnd = Math.abs(rightEndTS - leftEndTS);
            return this.getOperator().isNegated() ^ (distStart <= this.startDev && distEnd <= this.endDev);
        }

        @Override
        public String toString() {
            return "coincides[" + this.startDev + ", " + this.endDev + "]";
        }

        @Override
        public int hashCode() {
            int PRIME = 31;
            int result = super.hashCode();
            result = 31 * result + (int)(this.endDev ^ this.endDev >>> 32);
            result = 31 * result + (int)(this.startDev ^ this.startDev >>> 32);
            return result;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!super.equals(obj)) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            CoincidesEvaluator other = (CoincidesEvaluator)obj;
            return this.endDev == other.endDev && this.startDev == other.startDev;
        }

        private void setParameters(long[] parameters) {
            if (parameters == null || parameters.length == 0) {
                this.startDev = 0L;
                this.endDev = 0L;
                return;
            }
            long[] lArray = parameters;
            int n = lArray.length;
            for (int i = 0; i < n; ++i) {
                Long param = lArray[i];
                if (param >= 0L) continue;
                throw new RuntimeException("[Coincides Evaluator]: negative values not allowed for temporal distance thresholds: '" + this.paramText + "'");
            }
            if (parameters.length == 1) {
                this.startDev = parameters[0];
                this.endDev = parameters[0];
            } else if (parameters.length == 2) {
                this.startDev = parameters[0];
                this.endDev = parameters[1];
            } else {
                throw new RuntimeException("[Coincides Evaluator]: Not possible to have more than 2 parameters: '" + this.paramText + "'");
            }
        }
    }
}

