/*
 * Decompiled with CFR 0.152.
 */
package org.drools.kiesession.entrypoints;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.drools.base.definitions.rule.impl.RuleImpl;
import org.drools.base.reteoo.PropertySpecificUtil;
import org.drools.base.rule.EntryPointId;
import org.drools.base.rule.TypeDeclaration;
import org.drools.core.RuleBaseConfiguration;
import org.drools.core.WorkingMemoryEntryPoint;
import org.drools.core.base.TraitHelper;
import org.drools.core.common.ClassAwareObjectStore;
import org.drools.core.common.DefaultEventHandle;
import org.drools.core.common.EqualityKey;
import org.drools.core.common.IdentityObjectStore;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.common.InternalWorkingMemory;
import org.drools.core.common.InternalWorkingMemoryEntryPoint;
import org.drools.core.common.ObjectStore;
import org.drools.core.common.ObjectStoreWrapper;
import org.drools.core.common.ObjectTypeConfigurationRegistry;
import org.drools.core.common.PropagationContext;
import org.drools.core.common.PropagationContextFactory;
import org.drools.core.common.ReteEvaluator;
import org.drools.core.common.SuperCacheFixer;
import org.drools.core.common.TruthMaintenanceSystemFactory;
import org.drools.core.impl.InternalRuleBase;
import org.drools.core.reteoo.EntryPointNode;
import org.drools.core.reteoo.ObjectTypeConf;
import org.drools.core.reteoo.ObjectTypeNode;
import org.drools.core.reteoo.RuntimeComponentFactory;
import org.drools.core.reteoo.TerminalNode;
import org.drools.core.reteoo.TupleImpl;
import org.drools.core.rule.accessor.FactHandleFactory;
import org.drools.core.rule.consequence.InternalMatch;
import org.drools.util.bitmask.AllSetBitMask;
import org.drools.util.bitmask.BitMask;
import org.kie.api.conf.KieBaseMutabilityOption;
import org.kie.api.prototype.PrototypeFactInstance;
import org.kie.api.runtime.ObjectFilter;
import org.kie.api.runtime.rule.FactHandle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NamedEntryPoint
implements InternalWorkingMemoryEntryPoint,
PropertyChangeListener {
    protected static final Logger log = LoggerFactory.getLogger(NamedEntryPoint.class);
    protected static final Class<?>[] ADD_REMOVE_PROPERTY_CHANGE_LISTENER_ARG_TYPES = new Class[]{PropertyChangeListener.class};
    protected final Object[] addRemovePropertyChangeListenerArgs = new Object[]{this};
    private ObjectStore objectStore;
    protected transient InternalRuleBase ruleBase;
    protected EntryPointId entryPoint;
    protected EntryPointNode entryPointNode;
    protected ReteEvaluator reteEvaluator;
    protected FactHandleFactory handleFactory;
    protected PropagationContextFactory pctxFactory;
    protected ReentrantLock lock;
    protected Set<InternalFactHandle> dynamicFacts = null;
    private boolean isEqualityBehaviour = false;
    private Object ruleUnit;

    protected NamedEntryPoint() {
        this.lock = null;
        this.reteEvaluator = null;
    }

    public NamedEntryPoint(EntryPointId entryPoint, EntryPointNode entryPointNode, ReteEvaluator reteEvaluator) {
        this.entryPoint = entryPoint;
        this.entryPointNode = entryPointNode;
        this.reteEvaluator = reteEvaluator;
        this.ruleBase = this.reteEvaluator.getKnowledgeBase();
        this.lock = reteEvaluator.getRuleSessionConfiguration().isThreadSafe() ? new ReentrantLock() : null;
        this.handleFactory = this.reteEvaluator.getFactHandleFactory();
        RuleBaseConfiguration conf = this.ruleBase.getRuleBaseConfiguration();
        this.pctxFactory = RuntimeComponentFactory.get().getPropagationContextFactory();
        this.isEqualityBehaviour = RuleBaseConfiguration.AssertBehaviour.EQUALITY.equals((Object)conf.getAssertBehaviour());
        this.objectStore = this.createObjectStore(entryPoint, conf, reteEvaluator);
    }

    protected ObjectStore createObjectStore(EntryPointId entryPoint, RuleBaseConfiguration conf, ReteEvaluator reteEvaluator) {
        boolean useClassAwareStore = this.isEqualityBehaviour || ((KieBaseMutabilityOption)conf.getOption(KieBaseMutabilityOption.KEY)).isMutabilityEnabled();
        return useClassAwareStore ? new ClassAwareObjectStore(this.isEqualityBehaviour, (Lock)this.lock) : new IdentityObjectStore();
    }

    public void lock() {
        if (this.lock != null) {
            this.lock.lock();
        }
    }

    public void unlock() {
        if (this.lock != null) {
            this.lock.unlock();
        }
    }

    public void reset() {
        this.objectStore.clear();
        if (TruthMaintenanceSystemFactory.present()) {
            TruthMaintenanceSystemFactory.get().clearTruthMaintenanceSystem((InternalWorkingMemoryEntryPoint)this);
        }
    }

    public ObjectStore getObjectStore() {
        return this.objectStore;
    }

    public EntryPointNode getEntryPointNode() {
        return this.entryPointNode;
    }

    public FactHandleFactory getHandleFactory() {
        return this.handleFactory;
    }

    public FactHandle insert(Object object) {
        return this.insert(object, false, null, null);
    }

    public FactHandle insert(Object object, boolean dynamic) {
        return this.insert(object, dynamic, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public FactHandle insert(Object object, boolean dynamic, RuleImpl rule, TerminalNode terminalNode) {
        if (object == null) {
            return null;
        }
        try {
            InternalFactHandle handle;
            this.reteEvaluator.startOperation(ReteEvaluator.InternalOperationType.INSERT);
            ObjectTypeConf typeConf = this.getObjectTypeConfigurationRegistry().getOrCreateObjectTypeConf(this.entryPoint, object);
            PropagationContext propagationContext = this.pctxFactory.createPropagationContext(this.reteEvaluator.getNextPropagationIdCounter(), PropagationContext.Type.INSERTION, rule, terminalNode, null, this.entryPoint);
            if (this.reteEvaluator.isSequential()) {
                InternalFactHandle handle2 = this.createHandle(object, typeConf);
                propagationContext.setFactHandle((FactHandle)handle2);
                this.insert(handle2, object, rule, typeConf, propagationContext);
                InternalFactHandle internalFactHandle = handle2;
                return internalFactHandle;
            }
            try {
                this.lock();
                handle = this.objectStore.getHandleForObject(object);
                if (typeConf.isTMSEnabled()) {
                    if (handle != null && handle.getEqualityKey().getStatus() == 1) {
                        InternalFactHandle internalFactHandle = handle;
                        return internalFactHandle;
                    }
                    handle = TruthMaintenanceSystemFactory.get().getOrCreateTruthMaintenanceSystem((InternalWorkingMemoryEntryPoint)this).insertOnTms(object, typeConf, propagationContext, handle, this::createHandle);
                } else {
                    if (handle != null) {
                        InternalFactHandle internalFactHandle = handle;
                        return internalFactHandle;
                    }
                    handle = this.createHandle(object, typeConf);
                }
                propagationContext.setFactHandle((FactHandle)handle);
                if (dynamic || typeConf.isDynamic()) {
                    this.addPropertyChangeListener(handle, dynamic);
                }
                this.insert(handle, object, rule, typeConf, propagationContext);
            }
            finally {
                this.unlock();
            }
            InternalFactHandle internalFactHandle = handle;
            return internalFactHandle;
        }
        finally {
            this.reteEvaluator.endOperation(ReteEvaluator.InternalOperationType.INSERT);
        }
    }

    public void insert(InternalFactHandle handle) {
        Object object = handle.getObject();
        ObjectTypeConf typeConf = this.getObjectTypeConfigurationRegistry().getOrCreateObjectTypeConf(this.entryPoint, object);
        this.insert(handle, object, null, null, typeConf);
    }

    public void insert(InternalFactHandle handle, Object object, RuleImpl rule, TerminalNode terminalNode, ObjectTypeConf typeConf) {
        PropagationContext pctx = this.pctxFactory.createPropagationContext(this.reteEvaluator.getNextPropagationIdCounter(), PropagationContext.Type.INSERTION, rule, terminalNode, handle, this.entryPoint);
        this.insert(handle, object, rule, typeConf, pctx);
    }

    public void insert(InternalFactHandle handle, Object object, RuleImpl rule, ObjectTypeConf typeConf, PropagationContext pctx) {
        this.ruleBase.executeQueuedActions();
        this.objectStore.addHandle(handle, object);
        this.entryPointNode.assertObject(handle, pctx, typeConf, this.reteEvaluator);
        this.reteEvaluator.getRuleRuntimeEventSupport().fireObjectInserted(pctx, (FactHandle)handle, object, this.reteEvaluator);
    }

    public FactHandle insertAsync(Object object) {
        ObjectTypeConf typeConf = this.getObjectTypeConfigurationRegistry().getOrCreateObjectTypeConf(this.entryPoint, object);
        PropagationContext pctx = this.pctxFactory.createPropagationContext(this.reteEvaluator.getNextPropagationIdCounter(), PropagationContext.Type.INSERTION, null, null, null, this.entryPoint);
        InternalFactHandle handle = this.createHandle(object, typeConf);
        pctx.setFactHandle((FactHandle)handle);
        this.entryPointNode.assertObject(handle, pctx, typeConf, this.reteEvaluator);
        this.reteEvaluator.getRuleRuntimeEventSupport().fireObjectInserted(pctx, (FactHandle)handle, object, this.reteEvaluator);
        return handle;
    }

    public void update(FactHandle factHandle, Object object) {
        this.update((InternalFactHandle)factHandle, object, PropertySpecificUtil.allSetBitMask(), Object.class, null);
    }

    public void update(FactHandle handle, Object object, String ... modifiedProperties) {
        BitMask mask = NamedEntryPoint.calculateUpdateBitMask(this.ruleBase, object, modifiedProperties);
        this.update((InternalFactHandle)handle, object, mask, object.getClass(), null);
    }

    public static BitMask calculateUpdateBitMask(InternalRuleBase ruleBase, Object object, String[] modifiedProperties) {
        boolean isPropertyReactive;
        String modifiedTypeName;
        List accessibleProperties;
        if (object instanceof PrototypeFactInstance) {
            PrototypeFactInstance p = (PrototypeFactInstance)object;
            accessibleProperties = new ArrayList(p.getPrototype().getFieldNames());
            modifiedTypeName = p.getPrototype().getFullName();
            isPropertyReactive = !accessibleProperties.isEmpty();
        } else {
            Class<?> modifiedClass = object.getClass();
            modifiedTypeName = modifiedClass.getName();
            TypeDeclaration typeDeclaration = ruleBase.getOrCreateExactTypeDeclaration(modifiedClass);
            isPropertyReactive = typeDeclaration.isPropertyReactive();
            accessibleProperties = isPropertyReactive ? typeDeclaration.getAccessibleProperties() : null;
        }
        return isPropertyReactive ? PropertySpecificUtil.calculatePositiveMask((String)modifiedTypeName, Arrays.asList(modifiedProperties), accessibleProperties) : AllSetBitMask.get();
    }

    public void update(FactHandle factHandle, Object object, BitMask mask, Class<?> modifiedClass, InternalMatch internalMatch) {
        this.update((InternalFactHandle)factHandle, object, mask, modifiedClass, internalMatch);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InternalFactHandle update(InternalFactHandle handle, Object object, BitMask mask, Class<?> modifiedClass, InternalMatch internalMatch) {
        this.lock();
        try {
            this.reteEvaluator.startOperation(ReteEvaluator.InternalOperationType.UPDATE);
            try {
                ObjectTypeConf typeConf;
                Object originalObject;
                boolean changedObject;
                this.ruleBase.executeQueuedActions();
                if (handle.isDisconnected()) {
                    InternalFactHandle reconnectedHandle = this.objectStore.reconnect(handle);
                    if (reconnectedHandle == null) {
                        handle.setDisconnected(false);
                        this.insert(handle, object, null, null, this.getObjectTypeConfigurationRegistry().getObjectTypeConf(object));
                        InternalFactHandle internalFactHandle = handle;
                        return internalFactHandle;
                    }
                    handle = reconnectedHandle;
                }
                boolean bl = changedObject = (originalObject = handle.getObject()) != object;
                if (!handle.getEntryPointId().equals((Object)this.entryPoint)) {
                    throw new IllegalArgumentException("Invalid Entry Point. You updated the FactHandle on entry point '" + handle.getEntryPointId() + "' instead of '" + this.getEntryPointId() + "'");
                }
                if (handle.isExpired()) {
                    ((DefaultEventHandle)handle).setPendingRemoveFromStore(true);
                }
                ObjectTypeConf objectTypeConf = typeConf = changedObject ? this.getObjectTypeConfigurationRegistry().getOrCreateObjectTypeConf(this.entryPoint, object) : this.getObjectTypeConfigurationRegistry().getObjectTypeConf(object);
                if (changedObject || this.isEqualityBehaviour) {
                    this.objectStore.updateHandle(handle, object);
                }
                this.handleFactory.increaseFactHandleRecency(handle);
                PropagationContext propagationContext = this.pctxFactory.createPropagationContext(this.reteEvaluator.getNextPropagationIdCounter(), PropagationContext.Type.MODIFICATION, internalMatch == null ? null : internalMatch.getRule(), internalMatch == null ? null : SuperCacheFixer.asTerminalNode((TupleImpl)internalMatch.getTuple()), handle, this.entryPoint, mask, modifiedClass, null);
                if (typeConf.isTMSEnabled()) {
                    TruthMaintenanceSystemFactory.get().getOrCreateTruthMaintenanceSystem((InternalWorkingMemoryEntryPoint)this).updateOnTms(handle, object, internalMatch);
                }
                this.beforeUpdate(handle, object, internalMatch, originalObject, propagationContext);
                this.update(handle, object, originalObject, typeConf, propagationContext);
            }
            finally {
                this.reteEvaluator.endOperation(ReteEvaluator.InternalOperationType.UPDATE);
            }
        }
        finally {
            this.unlock();
        }
        return handle;
    }

    protected void beforeUpdate(InternalFactHandle handle, Object object, InternalMatch internalMatch, Object originalObject, PropagationContext propagationContext) {
    }

    public void update(InternalFactHandle handle, Object object, Object originalObject, ObjectTypeConf typeConf, PropagationContext propagationContext) {
        this.entryPointNode.modifyObject(handle, propagationContext, typeConf, this.reteEvaluator);
        this.reteEvaluator.getRuleRuntimeEventSupport().fireObjectUpdated(propagationContext, (FactHandle)handle, originalObject, object, this.reteEvaluator);
    }

    public void retract(FactHandle handle) {
        this.delete(handle);
    }

    public void delete(FactHandle handle) {
        this.delete(handle, null, null);
    }

    public void delete(FactHandle handle, FactHandle.State fhState) {
        this.delete(handle, null, null, fhState);
    }

    public void delete(FactHandle factHandle, RuleImpl rule, TerminalNode terminalNode) {
        this.delete(factHandle, rule, terminalNode, FactHandle.State.ALL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void delete(FactHandle factHandle, RuleImpl rule, TerminalNode terminalNode, FactHandle.State fhState) {
        if (factHandle == null) {
            throw new IllegalArgumentException("FactHandle cannot be null ");
        }
        this.lock();
        try {
            this.reteEvaluator.startOperation(ReteEvaluator.InternalOperationType.DELETE);
            try {
                this.ruleBase.executeQueuedActions();
                InternalFactHandle handle = (InternalFactHandle)factHandle;
                if (handle.getId() == -1L) {
                    return;
                }
                if (handle.isDisconnected()) {
                    handle = this.objectStore.reconnect(handle);
                }
                if (handle == null) {
                    log.warn("The factHandle doesn't exist so cannot be deleted. " + factHandle.toExternalForm());
                    return;
                }
                if (!handle.getEntryPointId().equals((Object)this.entryPoint)) {
                    throw new IllegalArgumentException("Invalid Entry Point. You updated the FactHandle on entry point '" + handle.getEntryPointId() + "' instead of '" + this.getEntryPointId() + "'");
                }
                EqualityKey key = handle.getEqualityKey();
                if (fhState.isStated()) {
                    this.deleteStated(rule, terminalNode, handle, key);
                }
                if (!fhState.isLogical()) return;
                this.deleteLogical(key);
                return;
            }
            finally {
                this.reteEvaluator.endOperation(ReteEvaluator.InternalOperationType.DELETE);
            }
        }
        finally {
            this.unlock();
        }
    }

    private void deleteStated(RuleImpl rule, TerminalNode terminalNode, InternalFactHandle handle, EqualityKey key) {
        if (key != null && key.getStatus() == 2) {
            return;
        }
        this.beforeDestroy(rule, terminalNode, handle);
        Object object = handle.getObject();
        ObjectTypeConf typeConf = this.getObjectTypeConfigurationRegistry().getObjectTypeConf(object);
        if (typeConf.isDynamic()) {
            this.removePropertyChangeListener((FactHandle)handle, true);
        }
        PropagationContext propagationContext = this.delete(handle, object, typeConf, rule, terminalNode);
        this.deleteFromTMS(handle, key, typeConf, propagationContext);
        this.handleFactory.destroyFactHandle(handle);
    }

    protected void beforeDestroy(RuleImpl rule, TerminalNode terminalNode, InternalFactHandle handle) {
    }

    private void deleteFromTMS(InternalFactHandle handle, EqualityKey key, ObjectTypeConf typeConf, PropagationContext propagationContext) {
        if (typeConf.isTMSEnabled() && key != null) {
            TruthMaintenanceSystemFactory.get().getOrCreateTruthMaintenanceSystem((InternalWorkingMemoryEntryPoint)this).deleteFromTms(handle, key, propagationContext);
        }
    }

    private void deleteLogical(EqualityKey key) {
        if (key != null && key.getStatus() == 2) {
            TruthMaintenanceSystemFactory.get().getOrCreateTruthMaintenanceSystem((InternalWorkingMemoryEntryPoint)this).delete((FactHandle)key.getLogicalFactHandle());
        }
    }

    public PropagationContext delete(InternalFactHandle handle, Object object, ObjectTypeConf typeConf, RuleImpl rule, TerminalNode terminalNode) {
        return this.delete(handle, object, typeConf, rule, terminalNode, false);
    }

    public PropagationContext immediateDelete(InternalFactHandle handle, Object object, ObjectTypeConf typeConf, RuleImpl rule, TerminalNode terminalNode) {
        return this.delete(handle, object, typeConf, rule, terminalNode, true);
    }

    private PropagationContext delete(InternalFactHandle handle, Object object, ObjectTypeConf typeConf, RuleImpl rule, TerminalNode terminalNode, boolean immediate) {
        PropagationContext propagationContext = this.pctxFactory.createPropagationContext(this.reteEvaluator.getNextPropagationIdCounter(), PropagationContext.Type.DELETION, rule, terminalNode, handle, this.entryPoint);
        if (immediate) {
            this.entryPointNode.immediateDeleteObject(handle, propagationContext, typeConf, this.reteEvaluator);
        } else {
            this.entryPointNode.retractObject(handle, propagationContext, typeConf, this.reteEvaluator);
        }
        this.afterRetract(handle, rule, terminalNode);
        this.objectStore.removeHandle(handle);
        this.reteEvaluator.getRuleRuntimeEventSupport().fireObjectRetracted(propagationContext, (FactHandle)handle, object, this.reteEvaluator);
        return propagationContext;
    }

    protected void afterRetract(InternalFactHandle handle, RuleImpl rule, TerminalNode terminalNode) {
    }

    public void removeFromObjectStore(InternalFactHandle handle) {
        this.objectStore.removeHandle(handle);
        ObjectTypeConf typeConf = this.getObjectTypeConfigurationRegistry().getObjectTypeConf(handle.getObject());
        this.deleteFromTMS(handle, handle.getEqualityKey(), typeConf, null);
    }

    protected void addPropertyChangeListener(InternalFactHandle handle, boolean dynamicFlag) {
        Object object = handle.getObject();
        try {
            Method method = object.getClass().getMethod("addPropertyChangeListener", ADD_REMOVE_PROPERTY_CHANGE_LISTENER_ARG_TYPES);
            method.invoke(object, this.addRemovePropertyChangeListenerArgs);
            if (dynamicFlag) {
                if (this.dynamicFacts == null) {
                    this.dynamicFacts = new HashSet<InternalFactHandle>();
                }
                this.dynamicFacts.add(handle);
            }
        }
        catch (NoSuchMethodException e) {
            log.error("Warning: Method addPropertyChangeListener not found on the class " + object.getClass() + " so Drools will be unable to process JavaBean PropertyChangeEvents on the asserted Object");
        }
        catch (IllegalArgumentException e) {
            log.error("Warning: The addPropertyChangeListener method on the class " + object.getClass() + " does not take a simple PropertyChangeListener argument so Drools will be unable to process JavaBean PropertyChangeEvents on the asserted Object");
        }
        catch (IllegalAccessException e) {
            log.error("Warning: The addPropertyChangeListener method on the class " + object.getClass() + " is not public so Drools will be unable to process JavaBean PropertyChangeEvents on the asserted Object");
        }
        catch (InvocationTargetException e) {
            log.error("Warning: The addPropertyChangeListener method on the class " + object.getClass() + " threw an InvocationTargetException so Drools will be unable to process JavaBean PropertyChangeEvents on the asserted Object: " + e.getMessage());
        }
        catch (SecurityException e) {
            log.error("Warning: The SecurityManager controlling the class " + object.getClass() + " did not allow the lookup of a addPropertyChangeListener method so Drools will be unable to process JavaBean PropertyChangeEvents on the asserted Object: " + e.getMessage());
        }
    }

    protected void removePropertyChangeListener(FactHandle handle, boolean removeFromSet) {
        Object object = ((InternalFactHandle)handle).getObject();
        try {
            if (this.dynamicFacts != null && removeFromSet) {
                this.dynamicFacts.remove(handle);
            }
            if (object != null) {
                Method mehod = object.getClass().getMethod("removePropertyChangeListener", ADD_REMOVE_PROPERTY_CHANGE_LISTENER_ARG_TYPES);
                mehod.invoke(object, this.addRemovePropertyChangeListenerArgs);
            }
        }
        catch (NoSuchMethodException mehod) {
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException("Warning: The removePropertyChangeListener method on the class " + object.getClass() + " does not take a simple PropertyChangeListener argument so Drools will be unable to stop processing JavaBean PropertyChangeEvents on the retracted Object");
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Warning: The removePropertyChangeListener method on the class " + object.getClass() + " is not public so Drools will be unable to stop processing JavaBean PropertyChangeEvents on the retracted Object");
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException("Warning: The removePropertyChangeL istener method on the class " + object.getClass() + " threw an InvocationTargetException so Drools will be unable to stop processing JavaBean PropertyChangeEvents on the retracted Object: " + e.getMessage());
        }
        catch (SecurityException e) {
            throw new RuntimeException("Warning: The SecurityManager controlling the class " + object.getClass() + " did not allow the lookup of a removePropertyChangeListener method so Drools will be unable to stop processing JavaBean PropertyChangeEvents on the retracted Object: " + e.getMessage());
        }
    }

    public ObjectTypeConfigurationRegistry getObjectTypeConfigurationRegistry() {
        return this.entryPointNode.getTypeConfReg();
    }

    public InternalRuleBase getKnowledgeBase() {
        return this.ruleBase;
    }

    public FactHandle getFactHandle(Object object) {
        return this.objectStore.getHandleForObject(object);
    }

    public EntryPointId getEntryPoint() {
        return this.entryPoint;
    }

    public ReteEvaluator getReteEvaluator() {
        return this.reteEvaluator;
    }

    public Object getObject(FactHandle factHandle) {
        return this.objectStore.getObjectForHandle((InternalFactHandle)factHandle);
    }

    public <T extends FactHandle> Collection<T> getFactHandles() {
        return new ObjectStoreWrapper(this.objectStore, null, 1);
    }

    public <T extends FactHandle> Collection<T> getFactHandles(ObjectFilter filter) {
        return new ObjectStoreWrapper(this.objectStore, filter, 1);
    }

    public Collection<?> getObjects() {
        return new ObjectStoreWrapper(this.objectStore, null, 0);
    }

    public Collection<?> getObjects(ObjectFilter filter) {
        return new ObjectStoreWrapper(this.objectStore, filter, 0);
    }

    public String getEntryPointId() {
        return this.entryPoint.getEntryPointId();
    }

    public long getFactCount() {
        return this.objectStore.size();
    }

    private InternalFactHandle createHandle(Object object, ObjectTypeConf typeConf) {
        return this.handleFactory.newFactHandle(object, typeConf, this.reteEvaluator, (WorkingMemoryEntryPoint)this);
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        Object object = event.getSource();
        FactHandle handle = this.getFactHandle(object);
        if (handle == null) {
            throw new RuntimeException("Update error: handle not found for object: " + object + ". Is it in the working memory?");
        }
        this.update(handle, object, event.getPropertyName());
    }

    public void dispose() {
        if (this.dynamicFacts != null) {
            for (InternalFactHandle handle : this.dynamicFacts) {
                this.removePropertyChangeListener((FactHandle)handle, false);
            }
            this.dynamicFacts = null;
        }
        for (ObjectTypeConf conf : this.getObjectTypeConfigurationRegistry().values()) {
            ObjectTypeNode otn;
            if (!conf.isDynamic() || (otn = conf.getConcreteObjectTypeNode()) == null) continue;
            Iterator it = otn.getFactHandlesIterator((InternalWorkingMemory)this.reteEvaluator);
            while (it.hasNext()) {
                this.removePropertyChangeListener((FactHandle)it.next(), false);
            }
        }
        this.reset();
    }

    public TraitHelper getTraitHelper() {
        throw new UnsupportedOperationException("In order to use traits you must add the drools-traits module to your classpath");
    }

    public PropagationContextFactory getPctxFactory() {
        return this.pctxFactory;
    }

    public String toString() {
        return this.entryPoint.toString();
    }

    public Object getRuleUnit() {
        return this.ruleUnit;
    }

    public void setRuleUnit(Object ruleUnit) {
        this.ruleUnit = ruleUnit;
    }
}

