/*
 * Decompiled with CFR 0.152.
 */
package org.drools.decisiontable.parser;

import java.util.ArrayList;
import java.util.List;
import org.drools.decisiontable.parser.DefaultRuleSheetListener;
import org.drools.template.model.Condition;
import org.drools.template.model.Consequence;
import org.drools.template.model.Rule;
import org.drools.template.model.SnippetBuilder;
import org.drools.util.StringUtils;

public class RuleMatrixSheetListener
extends DefaultRuleSheetListener {
    public static final String AGENDAGROUP_TAG = "AgendaGroup";
    public static final String PRECONDITION_TAG = "Precondition";
    public static final String ACTION_TAG = "Action";
    public static final String HORIZONTALCONDITION_TAG = "HorizontalCondition";
    public static final String VERTICALCONDITION_TAG = "VerticalCondition";
    private int ruleTableRow;
    private int ruleTableColumn;
    private String _currentAgendaGroup;
    private Condition _currentPrecondition;
    private String _action;
    private String _horizontalCondition;
    private String _verticalCondition;
    private List<Condition> _horizontalConditions = new ArrayList<Condition>();
    private Condition _currentVerticalCondition;
    private boolean isInRuleTable;
    private Rule firstRule;

    @Override
    public void newCell(int row, int column, String value, int mergedColStart) {
        if (!this.isInRuleTable) {
            super.newCell(row, column, value, mergedColStart);
            return;
        }
        if (StringUtils.isEmpty((CharSequence)value)) {
            return;
        }
        if (row == this.ruleTableRow && column > this.ruleTableColumn) {
            this._horizontalConditions.add(this.createCondition(value, this._horizontalCondition));
        } else if (row > this.ruleTableRow && column == this.ruleTableColumn) {
            this._currentVerticalCondition = this.createCondition(value, this._verticalCondition);
        } else if (row > this.ruleTableRow && column > this.ruleTableColumn) {
            this.createRule(row, column, value);
        }
    }

    private void createRule(int row, int column, String value) {
        Consequence consequence = this.createConsequence(value);
        Rule rule = this.firstRule;
        if (rule == null) {
            rule = new Rule("rule_" + row + "_" + column, null, row);
            this.addRule(rule);
        } else {
            this.firstRule = null;
            rule.setName("rule_" + row + "_" + column);
        }
        rule.setAgendaGroup(this._currentAgendaGroup);
        rule.addCondition(this._currentPrecondition);
        rule.addCondition(this._currentVerticalCondition);
        rule.addCondition(this._horizontalConditions.get(column - (this.ruleTableColumn + 1)));
        rule.addConsequence(consequence);
    }

    private Consequence createConsequence(String value) {
        SnippetBuilder snip = new SnippetBuilder(this._action);
        String result = snip.build(value);
        Consequence consequence = new Consequence();
        consequence.setSnippet(result);
        return consequence;
    }

    private Condition createCondition(String value, String conditionTemplate) {
        SnippetBuilder snip = new SnippetBuilder(conditionTemplate);
        String result = snip.build(value);
        Condition condition = new Condition();
        condition.setSnippet(result);
        return condition;
    }

    @Override
    public void newRow(int rowNumber, int columns) {
    }

    @Override
    public void finishSheet() {
    }

    @Override
    protected void postInitRuleTable(int row, int column, String value) {
        this.firstRule = this.getCurrentRule();
    }

    @Override
    protected void preInitRuleTable(int row, int column, String value) {
        this.ruleTableColumn = column;
        this.ruleTableRow = row;
        this.isInRuleTable = true;
        this._currentAgendaGroup = this.getProperties().getSingleProperty(AGENDAGROUP_TAG);
        this._action = this.getProperties().getSingleProperty(ACTION_TAG);
        this._horizontalCondition = this.getProperties().getSingleProperty(HORIZONTALCONDITION_TAG);
        this._verticalCondition = this.getProperties().getSingleProperty(VERTICALCONDITION_TAG);
        String precondition = this.getProperties().getSingleProperty(PRECONDITION_TAG);
        if (precondition != null) {
            this._currentPrecondition = new Condition();
            this._currentPrecondition.setSnippet(precondition);
        }
    }
}

