/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.builder.impl.processors;

import java.util.Collection;
import org.drools.compiler.builder.PackageRegistryManager;
import org.drools.compiler.builder.impl.BuildResultCollectorImpl;
import org.drools.compiler.builder.impl.processors.CompilationPhase;
import org.drools.compiler.builder.impl.processors.SinglePackagePhaseFactory;
import org.drools.compiler.compiler.PackageRegistry;
import org.drools.compiler.lang.descr.CompositePackageDescr;
import org.kie.internal.builder.KnowledgeBuilderResult;

public class IteratingPhase
implements CompilationPhase {
    private final String name;
    private final Collection<CompositePackageDescr> packages;
    private final PackageRegistryManager pkgRegistryManager;
    private final SinglePackagePhaseFactory phaseFactory;
    private final BuildResultCollectorImpl results = new BuildResultCollectorImpl();

    public IteratingPhase(String name, Collection<CompositePackageDescr> packages, PackageRegistryManager pkgRegistryManager, SinglePackagePhaseFactory phaseFactory) {
        this.name = name;
        this.packages = packages;
        this.pkgRegistryManager = pkgRegistryManager;
        this.phaseFactory = phaseFactory;
    }

    @Override
    public void process() {
        for (CompositePackageDescr compositePackageDescr : this.packages) {
            PackageRegistry packageRegistry = this.pkgRegistryManager.getOrCreatePackageRegistry(compositePackageDescr);
            CompilationPhase phase = this.phaseFactory.create(packageRegistry, compositePackageDescr);
            phase.process();
            this.results.addAll(phase.getResults());
            if (!this.results.hasErrors()) continue;
            return;
        }
    }

    @Override
    public Collection<? extends KnowledgeBuilderResult> getResults() {
        return this.results.getAllResults();
    }

    public String toString() {
        return "IteratingPhase(" + this.name + ")";
    }
}

