/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.compiler;

import org.drools.drl.ast.descr.FunctionDescr;
import org.drools.drl.parser.DroolsError;
import org.kie.internal.jci.CompilationProblem;

public class FunctionError
extends DroolsError {
    private final FunctionDescr functionDescr;
    private final Object object;
    private int[] errorLines;

    public FunctionError(FunctionDescr functionDescr, Object object, String message) {
        super(functionDescr.getResource(), "");
        this.functionDescr = functionDescr;
        this.object = object;
        this.setErrorLines();
        this.setMessage(this.createMessage(message));
    }

    public String getNamespace() {
        return this.functionDescr.getNamespace();
    }

    public FunctionDescr getFunctionDescr() {
        return this.functionDescr;
    }

    public Object getObject() {
        return this.object;
    }

    public int[] getLines() {
        return this.errorLines;
    }

    public String toString() {
        return this.getMessage();
    }

    private void setErrorLines() {
        Object object = this.object;
        if (object instanceof CompilationProblem[]) {
            CompilationProblem[] cp = (CompilationProblem[])object;
            this.errorLines = new int[cp.length];
            for (int i = 0; i < cp.length; ++i) {
                this.errorLines[i] = cp[i].getStartLine() - this.functionDescr.getOffset() + this.getFunctionDescr().getLine() - 1;
            }
        } else {
            this.errorLines = new int[1];
            this.errorLines[0] = this.functionDescr.getLine();
        }
    }

    private String createMessage(String message) {
        StringBuilder detail = new StringBuilder();
        Object object = this.object;
        if (object instanceof CompilationProblem[]) {
            CompilationProblem[] cp = (CompilationProblem[])object;
            for (int i = 0; i < cp.length; ++i) {
                detail.append(this.functionDescr.getName());
                detail.append(" (line:");
                detail.append(this.errorLines[i]);
                detail.append("): ");
                detail.append(cp[i].getMessage());
                detail.append("\n");
            }
        } else {
            object = this.object;
            if (object instanceof Exception) {
                Exception ex = (Exception)object;
                detail.append(" (line:");
                detail.append(this.errorLines[0]);
                detail.append("): ");
                detail.append(message);
                detail.append(" ");
                detail.append(ex.getClass().getName());
                if (ex.getMessage() != null) {
                    detail.append(": ");
                    detail.append(ex.getMessage());
                }
            }
        }
        return "[ function " + this.functionDescr.getName() + detail + " ]";
    }
}

