/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.builder.impl.resources;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import org.drools.compiler.builder.impl.KnowledgeBuilderConfigurationImpl;
import org.drools.compiler.builder.impl.resources.ResourceHandler;
import org.drools.drl.ast.descr.PackageDescr;
import org.drools.drl.extensions.YamlFactory;
import org.drools.drl.parser.DrlParser;
import org.drools.drl.parser.DroolsParserException;
import org.drools.drl.parser.ParserError;
import org.drools.io.DescrResource;
import org.kie.api.io.Resource;
import org.kie.api.io.ResourceConfiguration;
import org.kie.api.io.ResourceType;
import org.kie.internal.builder.conf.LanguageLevelOption;

public class YamlResourceHandler
extends ResourceHandler {
    public YamlResourceHandler(KnowledgeBuilderConfigurationImpl configuration) {
        super(configuration);
    }

    @Override
    public boolean handles(ResourceType type) {
        return type == ResourceType.YAML;
    }

    @Override
    public PackageDescr process(Resource resource, ResourceConfiguration resourceConfig) throws DroolsParserException, IOException {
        PackageDescr pkg;
        boolean hasErrors = false;
        if (resource instanceof DescrResource) {
            pkg = (PackageDescr)((DescrResource)resource).getDescr();
        } else {
            String drl = YamlFactory.loadFromResource((Resource)resource);
            DrlParser parser = new DrlParser((LanguageLevelOption)this.configuration.getOption(LanguageLevelOption.KEY));
            pkg = parser.parse((Reader)new StringReader(drl));
            this.results.addAll(parser.getErrors());
            if (pkg == null) {
                this.results.add(new ParserError(resource, "Parser returned a null Package", 0, 0));
            }
            hasErrors = parser.hasErrors();
        }
        if (pkg != null) {
            pkg.setResource(resource);
        }
        return hasErrors ? null : pkg;
    }
}

