/*
 * Decompiled with CFR 0.152.
 */
package org.drools.codegen.common;

import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.function.UnaryOperator;

public class AppPaths {
    public static final String TARGET_DIR;
    public static final String GENERATED_SOURCES_DIR;
    public static final String GENERATED_RESOURCES_DIR;
    public static final BuildTool BT;
    public static final String SRC_DIR = "src";
    public static final String RESOURCES_DIR = "resources";
    public static final String MAIN_DIR = "main";
    public static final String TEST_DIR = "test";
    private final Set<Path> projectPaths = new LinkedHashSet<Path>();
    private final Collection<Path> classesPaths = new ArrayList<Path>();
    private final boolean isJar;
    private final Path outputTarget;
    private final Path[] paths;
    private final Path firstProjectPath;
    private final Path[] resourcePaths;
    private final File[] resourceFiles;
    private final Path[] sourcePaths;

    public static AppPaths fromProjectDir(Path projectDir) {
        return AppPaths.fromProjectDir(projectDir, BT);
    }

    public static AppPaths fromTestDir(Path projectDir) {
        return AppPaths.fromTestDir(projectDir, BT);
    }

    static AppPaths fromProjectDir(Path projectDir, BuildTool bt) {
        return new AppPaths(Collections.singletonList(projectDir), Collections.emptyList(), false, bt, MAIN_DIR, false);
    }

    static AppPaths fromTestDir(Path projectDir, BuildTool bt) {
        return new AppPaths(Collections.singletonList(projectDir), Collections.emptyList(), false, bt, TEST_DIR, true);
    }

    protected AppPaths(List<Path> projectPaths, Collection<Path> classesPaths, boolean isJar, BuildTool bt, String resourcesBasePath, boolean isTest) {
        this.isJar = isJar;
        this.projectPaths.addAll(projectPaths);
        this.classesPaths.addAll(classesPaths);
        this.outputTarget = Paths.get(".", bt.OUTPUT_DIRECTORY);
        this.firstProjectPath = projectPaths.get(0);
        this.resourcePaths = AppPaths.getResourcePaths(this.projectPaths, resourcesBasePath, bt, isTest);
        this.paths = isJar ? AppPaths.getJarPaths(isJar, this.classesPaths) : this.resourcePaths;
        this.resourceFiles = AppPaths.getResourceFiles(this.resourcePaths);
        this.sourcePaths = AppPaths.getSourcePaths(this.projectPaths);
    }

    public Path[] getPaths() {
        return this.paths;
    }

    public Path getFirstProjectPath() {
        return this.firstProjectPath;
    }

    public File[] getResourceFiles() {
        return this.resourceFiles;
    }

    public Path[] getResourcePaths() {
        return this.resourcePaths;
    }

    public Path[] getSourcePaths() {
        return this.sourcePaths;
    }

    public Collection<Path> getClassesPaths() {
        return Collections.unmodifiableCollection(this.classesPaths);
    }

    public Path getOutputTarget() {
        return this.outputTarget;
    }

    public String toString() {
        return "AppPaths{projectPaths=" + this.projectPaths + ", classesPaths=" + this.classesPaths + ", isJar=" + this.isJar + "}";
    }

    static Path[] getJarPaths(boolean isInnerJar, Collection<Path> innerClassesPaths) {
        if (!isInnerJar) {
            throw new IllegalStateException("Not a jar");
        }
        return innerClassesPaths.toArray(new Path[0]);
    }

    static Path[] getResourcePaths(Set<Path> innerProjectPaths, String resourcesBasePath, BuildTool innerBt, boolean isTest) {
        Path[] resourcesPaths = AppPaths.transformPaths(innerProjectPaths, p -> p.resolve(Paths.get(SRC_DIR, resourcesBasePath, RESOURCES_DIR)));
        Path generatedResourcesPath = isTest ? innerBt.GENERATED_TEST_RESOURCES_PATH : innerBt.GENERATED_RESOURCES_PATH;
        Path[] generatedResourcesPaths = AppPaths.transformPaths(innerProjectPaths, p -> p.resolve(generatedResourcesPath));
        Path[] toReturn = new Path[resourcesPaths.length + generatedResourcesPaths.length];
        System.arraycopy(resourcesPaths, 0, toReturn, 0, resourcesPaths.length);
        System.arraycopy(generatedResourcesPaths, 0, toReturn, resourcesPaths.length, generatedResourcesPaths.length);
        return toReturn;
    }

    static File[] getResourceFiles(Path[] innerResourcePaths) {
        return (File[])Arrays.stream(innerResourcePaths).map(Path::toFile).toArray(File[]::new);
    }

    static Path[] getSourcePaths(Set<Path> innerProjectPaths) {
        return AppPaths.transformPaths(innerProjectPaths, p -> p.resolve(SRC_DIR));
    }

    static Path[] transformPaths(Collection<Path> paths, UnaryOperator<Path> f) {
        return (Path[])paths.stream().map(f).toArray(Path[]::new);
    }

    static {
        BT = BuildTool.findBuildTool();
        TARGET_DIR = AppPaths.BT.OUTPUT_DIRECTORY;
        GENERATED_SOURCES_DIR = AppPaths.BT.GENERATED_SOURCES_PATH.toString();
        GENERATED_RESOURCES_DIR = AppPaths.BT.GENERATED_RESOURCES_PATH.toString();
    }

    public static enum BuildTool {
        MAVEN("target", Path.of("target", "generated-sources"), Path.of("target", "generated-resources"), Path.of("target", "generated-test-resources"), Path.of("target", "classes"), Path.of("target", "test-classes")),
        GRADLE("build", Path.of("build", "generated", "sources"), Path.of("build", "generated", "resources"), Path.of("build", "generated", "test", "resources"), Path.of("build", "classes", "java", "main"), Path.of("build", "classes", "java", "test"));

        public final String OUTPUT_DIRECTORY;
        public final Path GENERATED_SOURCES_PATH;
        public final Path GENERATED_RESOURCES_PATH;
        public final Path GENERATED_TEST_RESOURCES_PATH;
        public final Path CLASSES_PATH;
        public final Path TEST_CLASSES_PATH;

        private BuildTool(String outputDirectory, Path generatedSourcesPath, Path generatedResourcesPath, Path generatedTestResourcesPath, Path classesPath, Path testClassesPath) {
            this.OUTPUT_DIRECTORY = outputDirectory;
            this.GENERATED_SOURCES_PATH = generatedSourcesPath;
            this.GENERATED_RESOURCES_PATH = generatedResourcesPath;
            this.GENERATED_TEST_RESOURCES_PATH = generatedTestResourcesPath;
            this.CLASSES_PATH = classesPath;
            this.TEST_CLASSES_PATH = testClassesPath;
        }

        public static BuildTool findBuildTool() {
            return System.getProperty("org.gradle.appname") == null ? MAVEN : GRADLE;
        }
    }
}

