/*
 * Decompiled with CFR 0.152.
 */
package org.drools.model.patterns;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.drools.model.Binding;
import org.drools.model.Condition;
import org.drools.model.Constraint;
import org.drools.model.Pattern;
import org.drools.model.SingleConstraint;
import org.drools.model.Variable;
import org.drools.model.constraints.AbstractConstraint;
import org.drools.model.impl.ModelComponent;
import org.drools.model.patterns.AbstractSinglePattern;

public class PatternImpl<T>
extends AbstractSinglePattern
implements Pattern<T>,
ModelComponent {
    private final Variable<T> variable;
    private final Condition.Type type;
    private Variable[] inputVariables;
    private Constraint constraint;
    private List<Binding> bindings;
    private Collection<String> watchedProps;
    private boolean passive;

    public PatternImpl(Variable<T> variable) {
        this(variable, SingleConstraint.TRUE);
    }

    public PatternImpl(Variable<T> variable, Constraint constraint) {
        this(variable, constraint, null, Condition.Type.PATTERN);
    }

    public PatternImpl(Variable<T> variable, Condition.Type type) {
        this(variable, (Constraint)SingleConstraint.TRUE, type);
    }

    public PatternImpl(Variable<T> variable, Constraint constraint, Condition.Type type) {
        this(variable, constraint, null, type);
    }

    public PatternImpl(Variable<T> variable, Constraint constraint, List<Binding> bindings) {
        this(variable, constraint, bindings, Condition.Type.PATTERN);
    }

    public PatternImpl(Variable<T> variable, Constraint constraint, List<Binding> bindings, Condition.Type type) {
        this.variable = variable;
        this.constraint = constraint;
        this.bindings = bindings;
        this.type = type;
    }

    @Override
    public Condition.Type getType() {
        return this.type;
    }

    @Override
    public Variable<T> getPatternVariable() {
        return this.variable;
    }

    @Override
    public Variable<?>[] getBoundVariables() {
        return new Variable[]{this.variable};
    }

    @Override
    public Variable[] getInputVariables() {
        if (this.inputVariables == null) {
            this.inputVariables = this.collectInputVariables();
        }
        return this.inputVariables;
    }

    @Override
    public Constraint getConstraint() {
        return this.constraint;
    }

    public boolean hasConstraints() {
        return this.constraint != SingleConstraint.TRUE;
    }

    public void addConstraint(Constraint constraint) {
        this.constraint = this.hasConstraints() ? ((AbstractConstraint)this.constraint).with(constraint) : constraint;
    }

    public void addBinding(Binding binding) {
        if (this.bindings == null) {
            this.bindings = new ArrayList<Binding>();
        }
        this.bindings.add(binding);
    }

    @Override
    public Collection<Binding> getBindings() {
        return this.bindings != null ? this.bindings : Collections.emptyList();
    }

    public void addWatchedProps(String[] props) {
        if (props == null || props.length == 0) {
            return;
        }
        if (this.watchedProps == null) {
            this.watchedProps = new LinkedHashSet<String>();
        }
        Collections.addAll(this.watchedProps, props);
    }

    @Override
    public String[] getWatchedProps() {
        return this.watchedProps != null ? this.watchedProps.toArray(new String[this.watchedProps.size()]) : new String[]{};
    }

    @Override
    public boolean isPassive() {
        return this.passive;
    }

    public void setPassive(boolean passive) {
        this.passive = passive;
    }

    private Variable[] collectInputVariables() {
        LinkedHashSet<Variable> varSet = new LinkedHashSet<Variable>();
        this.collectInputVariables(this.constraint, varSet);
        return varSet.toArray(new Variable[varSet.size()]);
    }

    private void collectInputVariables(Constraint constraint, Set<Variable> varSet) {
        if (constraint instanceof SingleConstraint) {
            Collections.addAll(varSet, ((SingleConstraint)constraint).getVariables());
        } else {
            for (Constraint child : constraint.getChildren()) {
                this.collectInputVariables(child, varSet);
            }
        }
    }

    @Override
    public boolean isEqualTo(ModelComponent o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PatternImpl)) {
            return false;
        }
        PatternImpl pattern = (PatternImpl)o;
        if (!ModelComponent.areEqualInModel(this.variable, pattern.variable)) {
            return false;
        }
        if (!ModelComponent.areEqualInModel(this.inputVariables, pattern.inputVariables)) {
            return false;
        }
        if (!ModelComponent.areEqualInModel(this.constraint, pattern.constraint)) {
            return false;
        }
        if (!ModelComponent.areEqualInModel(this.bindings, pattern.bindings)) {
            return false;
        }
        return this.watchedProps != null ? this.watchedProps.equals(pattern.watchedProps) : pattern.watchedProps == null;
    }

    public PatternImpl<T> negate() {
        this.constraint = this.constraint.negate();
        return this;
    }

    public String toString() {
        return "PatternImpl (type: " + this.type + ", inputVars: " + Arrays.toString(this.inputVariables) + ", outputVar: " + this.variable + ", constraint: " + this.constraint + ")";
    }

    @Override
    public PatternImpl cloneCondition() {
        return new PatternImpl<T>(this.variable, ((AbstractConstraint)this.constraint).cloneConstraint(), (List<Binding>)(this.bindings == null ? null : new ArrayList<Binding>(this.bindings)), this.type);
    }
}

