/*
 * Decompiled with CFR 0.152.
 */
package org.drools.base.rule;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collections;
import java.util.List;
import org.drools.base.base.ClassObjectType;
import org.drools.base.base.ObjectType;
import org.drools.base.factmodel.ClassDefinition;
import org.drools.base.factmodel.GeneratedFact;
import org.drools.base.facttemplates.FactTemplate;
import org.drools.base.facttemplates.FactTemplateObjectType;
import org.drools.base.rule.Annotated;
import org.drools.base.rule.accessor.ReadAccessor;
import org.drools.base.util.PropertyReactivityUtil;
import org.drools.base.util.TimeIntervalParser;
import org.drools.util.ClassUtils;
import org.kie.api.definition.KieDefinition;
import org.kie.api.definition.type.ClassReactive;
import org.kie.api.definition.type.Expires;
import org.kie.api.definition.type.PropertyReactive;
import org.kie.api.definition.type.Role;
import org.kie.api.io.Resource;
import org.kie.internal.builder.conf.PropertySpecificOption;
import org.kie.internal.definition.KnowledgeDefinition;

public class TypeDeclaration
implements KnowledgeDefinition,
Externalizable,
Comparable<TypeDeclaration> {
    public static final long NEVER_EXPIRES = -1L;
    public static final int ROLE_BIT = 1;
    public static final int TYPESAFE_BIT = 2;
    public static final int FORMAT_BIT = 4;
    public static final int KIND_BIT = 8;
    public static final int NATURE_BIT = 16;
    public int setMask = 0;
    private String typeName;
    private Role.Type role;
    private Format format;
    private Kind kind;
    private Nature nature;
    private String timestampAttribute;
    private String durationAttribute;
    private ReadAccessor durationExtractor;
    private ReadAccessor timestampExtractor;
    private transient Class<?> typeClass;
    private String typeClassName;
    private FactTemplate typeTemplate;
    private ClassDefinition typeClassDef;
    private Resource resource;
    private boolean dynamic;
    private boolean typesafe;
    private boolean novel;
    private boolean valid;
    private boolean propertyReactive;
    private boolean javaBased;
    private transient List<String> accessibleProperties;
    private transient ObjectType objectType;
    private long expirationOffset = -1L;
    private Expires.Policy expirationPolicy;
    private int order;

    public TypeDeclaration() {
        this.role = Role.Type.FACT;
        this.format = Format.POJO;
        this.kind = Kind.CLASS;
        this.nature = Nature.DECLARATION;
        this.valid = true;
    }

    private TypeDeclaration(Class<?> typeClass) {
        this(ClassUtils.getSimpleName(typeClass));
        this.setTypeClass(typeClass);
        this.javaBased = true;
        this.setTypeClassDef(new ClassDefinition(typeClass));
        Role role = typeClass.getAnnotation(Role.class);
        if (role != null) {
            this.setRole(role.value());
        }
        if (typeClass.getAnnotation(PropertyReactive.class) != null) {
            this.setPropertyReactive(true);
        }
    }

    public TypeDeclaration(String typeName) {
        this.typeName = typeName;
        this.role = Role.Type.FACT;
        this.format = Format.POJO;
        this.kind = Kind.CLASS;
        this.nature = Nature.DECLARATION;
        this.durationAttribute = null;
        this.timestampAttribute = null;
        this.typeTemplate = null;
        this.typesafe = true;
        this.valid = true;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.typeName = (String)in.readObject();
        this.role = (Role.Type)in.readObject();
        this.format = (Format)((Object)in.readObject());
        this.kind = (Kind)((Object)in.readObject());
        this.nature = (Nature)((Object)in.readObject());
        this.durationAttribute = (String)in.readObject();
        this.timestampAttribute = (String)in.readObject();
        this.typeClassName = (String)in.readObject();
        this.typeTemplate = (FactTemplate)in.readObject();
        this.typeClassDef = (ClassDefinition)in.readObject();
        this.durationExtractor = (ReadAccessor)in.readObject();
        this.timestampExtractor = (ReadAccessor)in.readObject();
        this.resource = (Resource)in.readObject();
        this.expirationOffset = in.readLong();
        this.expirationPolicy = (Expires.Policy)in.readObject();
        this.dynamic = in.readBoolean();
        this.typesafe = in.readBoolean();
        this.propertyReactive = in.readBoolean();
        this.valid = in.readBoolean();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.typeName);
        out.writeObject(this.role);
        out.writeObject((Object)this.format);
        out.writeObject((Object)this.kind);
        out.writeObject((Object)this.nature);
        out.writeObject(this.durationAttribute);
        out.writeObject(this.timestampAttribute);
        out.writeObject(this.typeClassName);
        out.writeObject(this.typeTemplate);
        out.writeObject(this.typeClassDef);
        out.writeObject(this.durationExtractor);
        out.writeObject(this.timestampExtractor);
        out.writeObject(this.resource);
        out.writeLong(this.expirationOffset);
        out.writeObject(this.expirationPolicy);
        out.writeBoolean(this.dynamic);
        out.writeBoolean(this.typesafe);
        out.writeBoolean(this.propertyReactive);
        out.writeBoolean(this.valid);
    }

    public int getSetMask() {
        return this.setMask;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public Role.Type getRole() {
        return this.role;
    }

    public void setRole(Role.Type role) {
        this.setMask |= 1;
        this.role = role;
    }

    public Format getFormat() {
        return this.format;
    }

    public void setFormat(Format format) {
        this.setMask |= 4;
        this.format = format;
    }

    public Kind getKind() {
        return this.kind;
    }

    public void setKind(Kind kind) {
        this.setMask |= 8;
        this.kind = kind;
    }

    public Nature getNature() {
        return this.nature;
    }

    public void setNature(Nature nature) {
        this.setMask |= 0x10;
        this.nature = nature;
    }

    public String getTimestampAttribute() {
        return this.timestampAttribute;
    }

    public void setTimestampAttribute(String timestampAttribute) {
        this.timestampAttribute = timestampAttribute;
    }

    public String getDurationAttribute() {
        return this.durationAttribute;
    }

    public void setDurationAttribute(String durationAttribute) {
        this.durationAttribute = durationAttribute;
    }

    public boolean isValid() {
        return this.valid;
    }

    public void setValid(boolean valid) {
        this.valid = valid;
    }

    public Class<?> getTypeClass() {
        return this.typeClass;
    }

    public void setTypeClass(Class<?> typeClass) {
        this.typeClass = typeClass;
        if (this.typeClassDef != null) {
            this.typeClassDef.setDefinedClass(this.typeClass);
        }
        if (this.typeClass != null) {
            this.typeClassName = this.typeClass.getName();
        }
    }

    public boolean isDefinition() {
        return this.nature == Nature.DEFINITION || this.isGeneratedFact();
    }

    public boolean isGeneratedFact() {
        return this.typeClass != null && GeneratedFact.class.isAssignableFrom(this.typeClass);
    }

    public FactTemplate getTypeTemplate() {
        return this.typeTemplate;
    }

    public void setTypeTemplate(FactTemplate typeTemplate) {
        this.typeTemplate = typeTemplate;
    }

    public boolean matches(Object clazz) {
        return clazz instanceof FactTemplate ? this.typeTemplate.equals(clazz) : this.typeClass.isAssignableFrom((Class)clazz);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.typeName == null ? 0 : this.typeName.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TypeDeclaration other = (TypeDeclaration)obj;
        return !(this.typeName == null ? other.typeName != null : !this.typeName.equals(other.typeName));
    }

    public ReadAccessor getDurationExtractor() {
        return this.durationExtractor;
    }

    public void setDurationExtractor(ReadAccessor durationExtractor) {
        this.durationExtractor = durationExtractor;
    }

    public ClassDefinition getTypeClassDef() {
        return this.typeClassDef;
    }

    public void setTypeClassDef(ClassDefinition typeClassDef) {
        this.typeClassDef = typeClassDef;
    }

    public ReadAccessor getTimestampExtractor() {
        return this.timestampExtractor;
    }

    public void setTimestampExtractor(ReadAccessor timestampExtractor) {
        this.timestampExtractor = timestampExtractor;
    }

    public Resource getResource() {
        return this.resource;
    }

    public void setResource(Resource resource) {
        this.resource = resource;
    }

    public ObjectType getObjectType() {
        if (this.objectType == null) {
            this.objectType = this.getFormat() == Format.POJO ? new ClassObjectType(this.getTypeClass()) : new FactTemplateObjectType(this.getTypeTemplate());
        }
        return this.objectType;
    }

    public long getExpirationOffset() {
        return this.expirationOffset;
    }

    public void setExpirationOffset(long expirationOffset) {
        this.expirationOffset = expirationOffset;
    }

    public Expires.Policy getExpirationPolicy() {
        return this.expirationPolicy;
    }

    public void setExpirationType(Expires.Policy expirationPolicy) {
        this.expirationPolicy = expirationPolicy;
    }

    public String getTypeClassName() {
        return this.typeClassName;
    }

    public void setTypeClassName(String typeClassName) {
        this.typeClassName = typeClassName;
    }

    public boolean isJavaBased() {
        return this.javaBased;
    }

    public boolean isDynamic() {
        return this.dynamic;
    }

    public void setDynamic(boolean dynamic) {
        this.dynamic = dynamic;
    }

    public boolean isTypesafe() {
        return this.typesafe;
    }

    public void setTypesafe(boolean typesafe) {
        this.setMask |= 2;
        this.typesafe = typesafe;
    }

    public boolean isPropertyReactive() {
        return this.propertyReactive;
    }

    public void setPropertyReactive(boolean propertyReactive) {
        this.propertyReactive = propertyReactive;
    }

    public boolean isNovel() {
        return this.novel;
    }

    public void setNovel(boolean novel) {
        this.novel = novel;
    }

    public List<String> getAccessibleProperties() {
        if (this.accessibleProperties == null) {
            this.accessibleProperties = this.propertyReactive ? PropertyReactivityUtil.getAccessibleProperties(this.getTypeClass()) : Collections.emptyList();
        }
        return this.accessibleProperties;
    }

    public String toString() {
        return "TypeDeclaration{typeName='" + this.typeName + "', role=" + this.role + ", format=" + this.format + ", kind=" + this.kind + ", nature=" + this.nature + "}";
    }

    public KieDefinition.KnowledgeType getKnowledgeType() {
        return KieDefinition.KnowledgeType.TYPE;
    }

    public String getNamespace() {
        return this.typeClass != null ? this.typeClass.getPackage().getName() : "";
    }

    public String getFullName() {
        return this.getNamespace() + "." + this.getTypeName();
    }

    public String getId() {
        return this.getTypeName();
    }

    public int getOrder() {
        return this.order;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    @Override
    public int compareTo(TypeDeclaration o) {
        return this.order - o.order;
    }

    public static TypeDeclaration createTypeDeclarationForBean(Class<?> cls) {
        return TypeDeclaration.createTypeDeclarationForBean(cls, PropertySpecificOption.ALWAYS);
    }

    public static TypeDeclaration createTypeDeclarationForBean(Class<?> cls, PropertySpecificOption propertySpecificOption) {
        return TypeDeclaration.createTypeDeclarationForBean(cls, new Annotated.ClassAdapter(cls), propertySpecificOption);
    }

    public static TypeDeclaration createTypeDeclarationForBean(Class<?> cls, Annotated annotated, PropertySpecificOption propertySpecificOption) {
        TypeDeclaration typeDeclaration = new TypeDeclaration(cls);
        TypeDeclaration.processTypeAnnotations(typeDeclaration, annotated, propertySpecificOption);
        return typeDeclaration;
    }

    public static void processTypeAnnotations(TypeDeclaration type, Annotated annotated, PropertySpecificOption propertySpecificOption) {
        TypeDeclaration.configureExpirationOffset(type, annotated);
        TypeDeclaration.configurePropertyReactivity(type, annotated, propertySpecificOption);
    }

    private static void configureExpirationOffset(TypeDeclaration type, Annotated annotated) {
        Expires expires = annotated.getTypedAnnotation(Expires.class);
        if (expires != null) {
            String expiration = expires.value();
            long offset = TimeIntervalParser.parseSingle(expiration);
            type.setExpirationOffset(offset == -1L ? Long.MAX_VALUE : offset);
            type.setExpirationType(expires.policy());
        }
    }

    private static void configurePropertyReactivity(TypeDeclaration type, Annotated annotated, PropertySpecificOption propertySpecificOption) {
        boolean propertyReactive = propertySpecificOption.isPropSpecific(annotated.hasAnnotation(PropertyReactive.class), annotated.hasAnnotation(ClassReactive.class));
        type.setPropertyReactive(propertyReactive);
    }

    public static enum Format {
        POJO,
        TEMPLATE;

    }

    public static enum Kind {
        CLASS,
        TRAIT,
        ENUM;

    }

    public static enum Nature {
        DECLARATION,
        DEFINITION;

        public static final String ID = "nature";

        public static Nature parseNature(String nature) {
            if ("declaration".equalsIgnoreCase(nature)) {
                return DECLARATION;
            }
            if ("definition".equalsIgnoreCase(nature)) {
                return DEFINITION;
            }
            return null;
        }
    }
}

