/*
 * Decompiled with CFR 0.152.
 */
package org.drools.base.base.extractors;

import java.lang.reflect.Method;
import java.util.Date;
import org.drools.base.base.BaseClassFieldReader;
import org.drools.base.base.ValueResolver;
import org.drools.base.base.ValueType;

public abstract class BaseObjectClassFieldReader
extends BaseClassFieldReader {
    private static final long serialVersionUID = 510L;

    public BaseObjectClassFieldReader() {
    }

    protected BaseObjectClassFieldReader(int index, Class<?> fieldType, ValueType valueType) {
        super(index, fieldType, valueType);
    }

    @Override
    public abstract Object getValue(ValueResolver var1, Object var2);

    @Override
    public boolean getBooleanValue(ValueResolver valueResolver, Object object) {
        Object value = this.getValue(valueResolver, object);
        if (value instanceof Boolean) {
            Boolean b = (Boolean)value;
            return b;
        }
        throw new RuntimeException("Conversion to boolean not supported from " + this.getExtractToClass().getName());
    }

    @Override
    public byte getByteValue(ValueResolver valueResolver, Object object) {
        Object value = this.getValue(valueResolver, object);
        if (value instanceof Character) {
            Character c = (Character)value;
            return (byte)c.charValue();
        }
        throw new RuntimeException("Conversion to byte not supported from " + this.getExtractToClass().getName());
    }

    @Override
    public char getCharValue(ValueResolver valueResolver, Object object) {
        Object value = this.getValue(valueResolver, object);
        if (value instanceof Character) {
            Character c = (Character)value;
            return c.charValue();
        }
        throw new RuntimeException("Conversion to char not supported from " + this.getExtractToClass().getName());
    }

    @Override
    public double getDoubleValue(ValueResolver valueResolver, Object object) {
        Object value = this.getValue(valueResolver, object);
        if (value instanceof Character) {
            Character c = (Character)value;
            return c.charValue();
        }
        if (value instanceof Number) {
            Number n = (Number)value;
            return n.doubleValue();
        }
        throw new RuntimeException("Conversion to double not supported from " + this.getExtractToClass().getName());
    }

    @Override
    public float getFloatValue(ValueResolver valueResolver, Object object) {
        Object value = this.getValue(valueResolver, object);
        if (value instanceof Character) {
            Character c = (Character)value;
            return c.charValue();
        }
        if (value instanceof Number) {
            Number n = (Number)value;
            return n.floatValue();
        }
        throw new RuntimeException("Conversion to float not supported from " + this.getExtractToClass().getName());
    }

    @Override
    public int getIntValue(ValueResolver valueResolver, Object object) {
        Object value = this.getValue(valueResolver, object);
        if (value instanceof Character) {
            Character c = (Character)value;
            return c.charValue();
        }
        if (value instanceof Number) {
            Number n = (Number)value;
            return n.intValue();
        }
        throw new RuntimeException("Conversion to int not supported from " + this.getExtractToClass().getName());
    }

    @Override
    public long getLongValue(ValueResolver valueResolver, Object object) {
        Object value = this.getValue(valueResolver, object);
        if (value instanceof Character) {
            Character c = (Character)value;
            return c.charValue();
        }
        if (value instanceof Number) {
            Number n = (Number)value;
            return n.longValue();
        }
        if (value instanceof Date) {
            Date d = (Date)value;
            return d.getTime();
        }
        throw new RuntimeException("Conversion to long not supported from " + this.getExtractToClass().getName());
    }

    @Override
    public boolean isNullValue(ValueResolver valueResolver, Object object) {
        return object == null || this.getValue(valueResolver, object) == null;
    }

    @Override
    public short getShortValue(ValueResolver valueResolver, Object object) {
        Object value = this.getValue(valueResolver, object);
        if (value instanceof Character) {
            Character c = (Character)value;
            return (short)c.charValue();
        }
        if (value instanceof Number) {
            Number n = (Number)value;
            return n.shortValue();
        }
        throw new RuntimeException("Conversion to short not supported from " + this.getExtractToClass().getName());
    }

    @Override
    public Method getNativeReadMethod() {
        try {
            return this.getClass().getMethod(this.getNativeReadMethodName(), ValueResolver.class, Object.class);
        }
        catch (Exception e) {
            throw new RuntimeException("This is a bug. Please report to development team: " + e.getMessage(), e);
        }
    }

    @Override
    public String getNativeReadMethodName() {
        Class<?> type = this.getExtractToClass();
        if (!type.isPrimitive()) {
            return "getValue";
        }
        return "get" + type.getName().substring(0, 1).toUpperCase() + type.getName().substring(1) + "Value";
    }

    @Override
    public int getHashCode(ValueResolver valueResolver, Object object) {
        Object value = this.getValue(valueResolver, object);
        return value != null ? value.hashCode() : 0;
    }
}

