/*
 * Decompiled with CFR 0.152.
 */
package org.drools.javaparser.ast.expr;

import java.util.Optional;
import java.util.function.Consumer;
import org.drools.javaparser.TokenRange;
import org.drools.javaparser.ast.AllFieldsConstructor;
import org.drools.javaparser.ast.Node;
import org.drools.javaparser.ast.expr.Expression;
import org.drools.javaparser.ast.nodeTypes.NodeWithType;
import org.drools.javaparser.ast.observer.ObservableProperty;
import org.drools.javaparser.ast.type.ClassOrInterfaceType;
import org.drools.javaparser.ast.type.Type;
import org.drools.javaparser.ast.visitor.CloneVisitor;
import org.drools.javaparser.ast.visitor.GenericVisitor;
import org.drools.javaparser.ast.visitor.VoidVisitor;
import org.drools.javaparser.metamodel.ClassExprMetaModel;
import org.drools.javaparser.metamodel.JavaParserMetaModel;
import org.drools.javaparser.utils.Utils;

public final class ClassExpr
extends Expression
implements NodeWithType<ClassExpr, Type> {
    private Type type;

    public ClassExpr() {
        this(null, new ClassOrInterfaceType());
    }

    @AllFieldsConstructor
    public ClassExpr(Type type) {
        this(null, type);
    }

    public ClassExpr(TokenRange tokenRange, Type type) {
        super(tokenRange);
        this.setType(type);
        this.customInitialization();
    }

    @Override
    public <R, A> R accept(GenericVisitor<R, A> v, A arg) {
        return v.visit(this, arg);
    }

    @Override
    public <A> void accept(VoidVisitor<A> v, A arg) {
        v.visit(this, arg);
    }

    @Override
    public Type getType() {
        return this.type;
    }

    @Override
    public ClassExpr setType(Type type) {
        Utils.assertNotNull(type);
        if (type == this.type) {
            return this;
        }
        this.notifyPropertyChange(ObservableProperty.TYPE, this.type, type);
        if (this.type != null) {
            this.type.setParentNode(null);
        }
        this.type = type;
        this.setAsParentNodeOf(type);
        return this;
    }

    @Override
    public boolean remove(Node node) {
        if (node == null) {
            return false;
        }
        return super.remove(node);
    }

    @Override
    public ClassExpr clone() {
        return (ClassExpr)this.accept(new CloneVisitor(), null);
    }

    @Override
    public ClassExprMetaModel getMetaModel() {
        return JavaParserMetaModel.classExprMetaModel;
    }

    @Override
    public boolean replace(Node node, Node replacementNode) {
        if (node == null) {
            return false;
        }
        if (node == this.type) {
            this.setType((Type)replacementNode);
            return true;
        }
        return super.replace(node, replacementNode);
    }

    @Override
    public boolean isClassExpr() {
        return true;
    }

    @Override
    public ClassExpr asClassExpr() {
        return this;
    }

    @Override
    public void ifClassExpr(Consumer<ClassExpr> action) {
        action.accept(this);
    }

    @Override
    public Optional<ClassExpr> toClassExpr() {
        return Optional.of(this);
    }
}

