/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.org.xhtmlrenderer.docx;

import com.lowagie.text.DocumentException;
import com.lowagie.text.pdf.BaseFont;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.docx4j.org.xhtmlrenderer.css.constants.IdentValue;
import org.docx4j.org.xhtmlrenderer.css.value.FontSpecification;
import org.docx4j.org.xhtmlrenderer.docx.Docx4jFSFont;
import org.docx4j.org.xhtmlrenderer.docx.Docx4jFontDescription;
import org.docx4j.org.xhtmlrenderer.docx.Docx4jFontFamily;
import org.docx4j.org.xhtmlrenderer.extend.FontResolver;
import org.docx4j.org.xhtmlrenderer.layout.SharedContext;
import org.docx4j.org.xhtmlrenderer.render.FSFont;

public class Docx4jFontResolver
implements FontResolver {
    private Map _fontFamilies = Docx4jFontResolver.createInitialFontMap();
    private Map _fontCache = new HashMap();
    private final SharedContext _sharedContext;

    public Docx4jFontResolver(SharedContext sharedContext) {
        this._sharedContext = sharedContext;
    }

    public void flushCache() {
    }

    public FSFont resolveFont(SharedContext renderingContext, FontSpecification spec) {
        return null;
    }

    private FSFont resolveFont(SharedContext ctx, String[] families, float size, IdentValue weight, IdentValue style, IdentValue variant) {
        if (style != IdentValue.NORMAL && style != IdentValue.OBLIQUE && style != IdentValue.ITALIC) {
            style = IdentValue.NORMAL;
        }
        if (families != null) {
            for (int i = 0; i < families.length; ++i) {
                FSFont font = this.resolveFont(ctx, families[i], size, weight, style, variant);
                if (font == null) continue;
                return font;
            }
        }
        return this.resolveFont(ctx, "Serif", size, weight, style, variant);
    }

    private FSFont resolveFont(SharedContext ctx, String fontFamily, float size, IdentValue weight, IdentValue style, IdentValue variant) {
        String normalizedFontFamily = this.normalizeFontFamily(fontFamily);
        String cacheKey = Docx4jFontResolver.getHashName(normalizedFontFamily, weight, style);
        Docx4jFontDescription result = (Docx4jFontDescription)this._fontCache.get(cacheKey);
        if (result != null) {
            return new Docx4jFSFont(result, size);
        }
        Docx4jFontFamily family = (Docx4jFontFamily)this._fontFamilies.get(normalizedFontFamily);
        if (family != null && (result = family.match(this.convertWeightToInt(weight), style)) != null) {
            this._fontCache.put(cacheKey, result);
            return new Docx4jFSFont(result, size);
        }
        return null;
    }

    protected static String getHashName(String name, IdentValue weight, IdentValue style) {
        return name + "-" + weight + "-" + style;
    }

    private String normalizeFontFamily(String fontFamily) {
        String result = fontFamily;
        if (result.startsWith("\"")) {
            result = result.substring(1);
        }
        if (result.endsWith("\"")) {
            result = result.substring(0, result.length() - 1);
        }
        if (result.equalsIgnoreCase("serif")) {
            result = "Serif";
        } else if (result.equalsIgnoreCase("sans-serif")) {
            result = "SansSerif";
        } else if (result.equalsIgnoreCase("monospace")) {
            result = "Monospaced";
        }
        return result;
    }

    private int convertWeightToInt(IdentValue weight) {
        if (weight == IdentValue.NORMAL) {
            return 400;
        }
        if (weight == IdentValue.BOLD) {
            return 700;
        }
        if (weight == IdentValue.FONT_WEIGHT_100) {
            return 100;
        }
        if (weight == IdentValue.FONT_WEIGHT_200) {
            return 200;
        }
        if (weight == IdentValue.FONT_WEIGHT_300) {
            return 300;
        }
        if (weight == IdentValue.FONT_WEIGHT_400) {
            return 400;
        }
        if (weight == IdentValue.FONT_WEIGHT_500) {
            return 500;
        }
        if (weight == IdentValue.FONT_WEIGHT_600) {
            return 600;
        }
        if (weight == IdentValue.FONT_WEIGHT_700) {
            return 700;
        }
        if (weight == IdentValue.FONT_WEIGHT_800) {
            return 800;
        }
        if (weight == IdentValue.FONT_WEIGHT_900) {
            return 900;
        }
        if (weight == IdentValue.LIGHTER) {
            return 400;
        }
        if (weight == IdentValue.BOLDER) {
            return 700;
        }
        throw new IllegalArgumentException();
    }

    private static Map createInitialFontMap() {
        HashMap result = new HashMap();
        try {
            Docx4jFontResolver.addCourier(result);
            Docx4jFontResolver.addTimes(result);
            Docx4jFontResolver.addHelvetica(result);
        }
        catch (DocumentException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        return result;
    }

    private static BaseFont createFont(String name) throws DocumentException, IOException {
        return BaseFont.createFont((String)name, (String)"winansi", (boolean)true);
    }

    private static void addCourier(HashMap result) throws DocumentException, IOException {
        Docx4jFontFamily courier = new Docx4jFontFamily();
        courier.setName("Courier");
        courier.addFontDescription(new Docx4jFontDescription(Docx4jFontResolver.createFont("Courier-BoldOblique"), IdentValue.OBLIQUE, 700));
        courier.addFontDescription(new Docx4jFontDescription(Docx4jFontResolver.createFont("Courier-Oblique"), IdentValue.OBLIQUE, 400));
        courier.addFontDescription(new Docx4jFontDescription(Docx4jFontResolver.createFont("Courier-Bold"), IdentValue.NORMAL, 700));
        courier.addFontDescription(new Docx4jFontDescription(Docx4jFontResolver.createFont("Courier"), IdentValue.NORMAL, 400));
        result.put("DialogInput", courier);
        result.put("Monospaced", courier);
        result.put("Courier", courier);
    }

    private static void addTimes(HashMap result) throws DocumentException, IOException {
        Docx4jFontFamily times = new Docx4jFontFamily();
        times.setName("Times");
        times.addFontDescription(new Docx4jFontDescription(Docx4jFontResolver.createFont("Times-BoldItalic"), IdentValue.ITALIC, 700));
        times.addFontDescription(new Docx4jFontDescription(Docx4jFontResolver.createFont("Times-Italic"), IdentValue.ITALIC, 400));
        times.addFontDescription(new Docx4jFontDescription(Docx4jFontResolver.createFont("Times-Bold"), IdentValue.NORMAL, 700));
        times.addFontDescription(new Docx4jFontDescription(Docx4jFontResolver.createFont("Times-Roman"), IdentValue.NORMAL, 400));
        result.put("Serif", times);
        result.put("TimesRoman", times);
    }

    private static void addHelvetica(HashMap result) throws DocumentException, IOException {
        Docx4jFontFamily helvetica = new Docx4jFontFamily();
        helvetica.setName("Helvetica");
        helvetica.addFontDescription(new Docx4jFontDescription(Docx4jFontResolver.createFont("Helvetica-BoldOblique"), IdentValue.OBLIQUE, 700));
        helvetica.addFontDescription(new Docx4jFontDescription(Docx4jFontResolver.createFont("Helvetica-Oblique"), IdentValue.OBLIQUE, 400));
        helvetica.addFontDescription(new Docx4jFontDescription(Docx4jFontResolver.createFont("Helvetica-Bold"), IdentValue.NORMAL, 700));
        helvetica.addFontDescription(new Docx4jFontDescription(Docx4jFontResolver.createFont("Helvetica"), IdentValue.NORMAL, 400));
        result.put("Dialog", helvetica);
        result.put("SansSerif", helvetica);
    }
}

