/*
 * Decompiled with CFR 0.152.
 */
package org.dizitart.no2.store.memory;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import org.dizitart.no2.common.Constants;
import org.dizitart.no2.index.BoundingBox;
import org.dizitart.no2.store.AbstractNitriteStore;
import org.dizitart.no2.store.NitriteMap;
import org.dizitart.no2.store.NitriteRTree;
import org.dizitart.no2.store.events.StoreEventListener;
import org.dizitart.no2.store.events.StoreEvents;
import org.dizitart.no2.store.memory.InMemoryConfig;
import org.dizitart.no2.store.memory.InMemoryMap;
import org.dizitart.no2.store.memory.InMemoryRTree;

public final class InMemoryStore
extends AbstractNitriteStore<InMemoryConfig> {
    private final Map<String, NitriteMap<?, ?>> nitriteMapRegistry = new ConcurrentHashMap();
    private final Map<String, NitriteRTree<?, ?>> nitriteRTreeMapRegistry = new ConcurrentHashMap();
    private volatile boolean closed = false;

    @Override
    public void openOrCreate() {
        this.initEventBus();
        this.alert(StoreEvents.Opened);
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    @Override
    public boolean hasUnsavedChanges() {
        return false;
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public void commit() {
        this.alert(StoreEvents.Commit);
    }

    @Override
    public void close() {
        this.closed = true;
        Consumer<Map.Entry> closeConsumer = entry -> {
            if (entry.getValue() instanceof AutoCloseable) {
                try {
                    ((AutoCloseable)entry.getValue()).close();
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        };
        this.nitriteMapRegistry.entrySet().forEach(closeConsumer);
        this.nitriteRTreeMapRegistry.entrySet().forEach(closeConsumer);
        this.nitriteMapRegistry.clear();
        this.nitriteRTreeMapRegistry.clear();
        super.close();
    }

    @Override
    public boolean hasMap(String mapName) {
        return this.nitriteMapRegistry.containsKey(mapName) || this.nitriteRTreeMapRegistry.containsKey(mapName);
    }

    @Override
    public <Key, Value> NitriteMap<Key, Value> openMap(String mapName, Class<?> keyType, Class<?> valueType) {
        NitriteMap<?, ?> nitriteMap;
        if (this.nitriteMapRegistry.containsKey(mapName)) {
            nitriteMap = this.nitriteMapRegistry.get(mapName);
            if (nitriteMap.isClosed()) {
                this.nitriteMapRegistry.remove(mapName);
            } else {
                return nitriteMap;
            }
        }
        nitriteMap = new InMemoryMap(mapName, this);
        this.nitriteMapRegistry.put(mapName, nitriteMap);
        return nitriteMap;
    }

    @Override
    public <Key extends BoundingBox, Value> NitriteRTree<Key, Value> openRTree(String rTreeName, Class<?> keyType, Class<?> valueType) {
        if (this.nitriteRTreeMapRegistry.containsKey(rTreeName)) {
            return (InMemoryRTree)this.nitriteRTreeMapRegistry.get(rTreeName);
        }
        InMemoryRTree rTree = new InMemoryRTree(rTreeName, this);
        this.nitriteRTreeMapRegistry.put(rTreeName, rTree);
        return rTree;
    }

    @Override
    public void closeMap(String mapName) {
        this.nitriteMapRegistry.remove(mapName);
    }

    @Override
    public void closeRTree(String rTreeName) {
        this.nitriteRTreeMapRegistry.remove(rTreeName);
    }

    @Override
    public void removeMap(String mapName) {
        if (this.nitriteMapRegistry.containsKey(mapName)) {
            NitriteMap<?, ?> nitriteMap = this.nitriteMapRegistry.get(mapName);
            if (!nitriteMap.isClosed() && !nitriteMap.isDropped()) {
                nitriteMap.clear();
                nitriteMap.close();
            }
            this.nitriteMapRegistry.remove(mapName);
            this.getCatalog().remove(mapName);
        }
    }

    @Override
    public void removeRTree(String rTreeName) {
        if (this.nitriteRTreeMapRegistry.containsKey(rTreeName)) {
            NitriteRTree<?, ?> rTree = this.nitriteRTreeMapRegistry.get(rTreeName);
            rTree.close();
            this.nitriteRTreeMapRegistry.remove(rTreeName);
            this.getCatalog().remove(rTreeName);
        }
    }

    @Override
    public String getStoreVersion() {
        return "InMemory/" + Constants.NITRITE_VERSION;
    }

    private void initEventBus() {
        if (((InMemoryConfig)this.getStoreConfig()).eventListeners() != null) {
            for (StoreEventListener eventListener : ((InMemoryConfig)this.getStoreConfig()).eventListeners()) {
                this.subscribe(eventListener);
            }
        }
    }
}

