/*
 * Decompiled with CFR 0.152.
 */
package org.dizitart.no2.store;

import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.InvalidKeySpecException;
import java.util.Arrays;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import lombok.Generated;
import org.dizitart.no2.common.util.SecureString;
import org.dizitart.no2.common.util.StringUtils;
import org.dizitart.no2.exceptions.NitriteSecurityException;
import org.dizitart.no2.store.NitriteMap;
import org.dizitart.no2.store.NitriteStore;
import org.dizitart.no2.store.UserCredential;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserAuthenticationService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(UserAuthenticationService.class);
    private static final String HASH_ALGORITHM = "PBKDF2WithHmacSHA256";
    private static final String OLD_HASH_ALGORITHM = "PBKDF2WithHmacSHA1";
    private final SecureRandom random;
    private final NitriteStore<?> store;

    public UserAuthenticationService(NitriteStore<?> store) {
        this.store = store;
        this.random = new SecureRandom();
    }

    /*
     * Enabled aggressive block sorting
     */
    public void authenticate(String username, String password) {
        boolean existing = this.store.hasMap("$nitrite_users");
        if (!StringUtils.isNullOrEmpty(password) && !StringUtils.isNullOrEmpty(username)) {
            if (!existing) {
                byte[] salt = this.getNextSalt();
                byte[] hash = this.hash(password.toCharArray(), salt, HASH_ALGORITHM);
                UserCredential userCredential = new UserCredential();
                userCredential.setPasswordHash(hash);
                userCredential.setPasswordSalt(salt);
                NitriteMap<String, UserCredential> userMap = this.store.openMap("$nitrite_users", String.class, UserCredential.class);
                userMap.put(username, userCredential);
                return;
            }
            NitriteMap userMap = this.store.openMap("$nitrite_users", String.class, UserCredential.class);
            UserCredential userCredential = (UserCredential)userMap.get(username);
            if (userCredential == null) throw new NitriteSecurityException("Username or password is invalid");
            byte[] salt = userCredential.getPasswordSalt();
            byte[] expectedHash = userCredential.getPasswordHash();
            if (!this.notExpectedPassword(password.toCharArray(), salt, expectedHash, HASH_ALGORITHM)) return;
            if (!this.notExpectedPassword(password.toCharArray(), salt, expectedHash, OLD_HASH_ALGORITHM)) return;
            throw new NitriteSecurityException("Username or password is invalid");
        }
        if (!existing) return;
        throw new NitriteSecurityException("Username or password is invalid");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void addOrUpdatePassword(boolean update, String username, SecureString oldPassword, SecureString newPassword) {
        NitriteMap<String, UserCredential> userMap = null;
        if (update) {
            userMap = this.store.openMap("$nitrite_users", String.class, UserCredential.class);
            UserCredential credential = (UserCredential)userMap.get(username);
            if (credential == null) throw new NitriteSecurityException("Username or password is invalid");
            byte[] salt = credential.getPasswordSalt();
            byte[] expectedHash = credential.getPasswordHash();
            if (this.notExpectedPassword(oldPassword.asString().toCharArray(), salt, expectedHash, HASH_ALGORITHM)) {
                throw new NitriteSecurityException("Username or password is invalid");
            }
        } else if (this.store.hasMap("$nitrite_users")) {
            throw new NitriteSecurityException("Cannot add new credentials");
        }
        if (userMap == null) {
            userMap = this.store.openMap("$nitrite_users", String.class, UserCredential.class);
        }
        byte[] salt = this.getNextSalt();
        byte[] hash = this.hash(newPassword.asString().toCharArray(), salt, HASH_ALGORITHM);
        UserCredential userCredential = new UserCredential();
        userCredential.setPasswordHash(hash);
        userCredential.setPasswordSalt(salt);
        userMap.put(username, userCredential);
    }

    private byte[] getNextSalt() {
        byte[] salt = new byte[16];
        this.random.nextBytes(salt);
        return salt;
    }

    private byte[] hash(char[] password, byte[] salt, String algorithm) {
        PBEKeySpec spec = new PBEKeySpec(password, salt, 10000, 256);
        Arrays.fill(password, '\u0000');
        try {
            SecretKeyFactory skf = SecretKeyFactory.getInstance(algorithm);
            byte[] byArray = skf.generateSecret(spec).getEncoded();
            return byArray;
        }
        catch (NoSuchAlgorithmException | InvalidKeySpecException e) {
            log.error("Error while hashing password", (Throwable)e);
            throw new NitriteSecurityException("Error while hashing a password: " + e.getMessage());
        }
        finally {
            spec.clearPassword();
        }
    }

    private boolean notExpectedPassword(char[] password, byte[] salt, byte[] expectedHash, String algorithm) {
        byte[] pwdHash = this.hash(password, salt, algorithm);
        Arrays.fill(password, '\u0000');
        if (pwdHash.length != expectedHash.length) {
            return true;
        }
        for (int i = 0; i < pwdHash.length; ++i) {
            if (pwdHash[i] == expectedHash[i]) continue;
            return true;
        }
        return false;
    }
}

