/*
 * Decompiled with CFR 0.152.
 */
package org.dizitart.no2.repository;

import java.util.ArrayList;
import java.util.Collections;
import org.dizitart.no2.collection.Document;
import org.dizitart.no2.collection.FindOptions;
import org.dizitart.no2.collection.NitriteCollection;
import org.dizitart.no2.collection.UpdateOptions;
import org.dizitart.no2.common.PersistentCollection;
import org.dizitart.no2.common.WriteResult;
import org.dizitart.no2.common.util.Iterables;
import org.dizitart.no2.common.util.ValidationUtils;
import org.dizitart.no2.filters.Filter;
import org.dizitart.no2.repository.Cursor;

public interface ObjectRepository<T>
extends PersistentCollection<T> {
    default public WriteResult insert(T object, T ... others) {
        ValidationUtils.notNull(object, "a null object cannot be inserted");
        if (others != null) {
            ValidationUtils.containsNull(others, "a null object cannot be inserted");
        }
        ArrayList<T> itemList = new ArrayList<T>();
        itemList.add(object);
        if (others != null) {
            Collections.addAll(itemList, others);
        }
        return this.insert(Iterables.toArray(itemList, this.getType()));
    }

    default public WriteResult update(Filter filter, T update) {
        return this.update(filter, update, UpdateOptions.updateOptions(false));
    }

    public WriteResult update(Filter var1, T var2, UpdateOptions var3);

    default public WriteResult update(Filter filter, Document update) {
        return this.update(filter, update, false);
    }

    public WriteResult update(Filter var1, Document var2, boolean var3);

    @Override
    default public WriteResult remove(Filter filter) {
        return this.remove(filter, false);
    }

    public WriteResult remove(Filter var1, boolean var2);

    default public Cursor<T> find() {
        return this.find(Filter.ALL, null);
    }

    default public Cursor<T> find(Filter filter) {
        return this.find(filter, null);
    }

    default public Cursor<T> find(FindOptions findOptions) {
        return this.find(Filter.ALL, findOptions);
    }

    public Cursor<T> find(Filter var1, FindOptions var2);

    public <I> T getById(I var1);

    public Class<T> getType();

    public NitriteCollection getDocumentCollection();
}

