/*
 * Decompiled with CFR 0.152.
 */
package org.dizitart.no2.repository;

import java.lang.reflect.Field;
import lombok.Generated;
import org.dizitart.no2.NitriteConfig;
import org.dizitart.no2.collection.Document;
import org.dizitart.no2.common.mapper.NitriteMapper;
import org.dizitart.no2.filters.Filter;
import org.dizitart.no2.filters.FluentFilter;
import org.dizitart.no2.filters.NitriteFilter;

class ObjectIdField {
    private String idFieldName;
    private String[] fieldNames;
    private Field field;
    private boolean isEmbedded;

    ObjectIdField() {
    }

    public String[] getEmbeddedFieldNames() {
        if (!this.isEmbedded) {
            return new String[]{this.idFieldName};
        }
        String[] fieldNames = new String[this.fieldNames.length];
        for (int i = 0; i < this.fieldNames.length; ++i) {
            String name = this.idFieldName + NitriteConfig.getFieldSeparator() + this.fieldNames[i];
            fieldNames[i] = name;
        }
        return fieldNames;
    }

    public Filter createUniqueFilter(Object value, NitriteMapper nitriteMapper) {
        if (this.getEmbeddedFieldNames().length == 1) {
            return FluentFilter.where(this.idFieldName).eq(value);
        }
        Document document = (Document)nitriteMapper.tryConvert(value, Document.class);
        Filter[] filters = new Filter[this.fieldNames.length];
        int index = 0;
        for (String field : this.fieldNames) {
            String filterField = this.idFieldName + NitriteConfig.getFieldSeparator() + field;
            Object fieldValue = document.get(field);
            filters[index++] = FluentFilter.where(filterField).eq(fieldValue);
        }
        NitriteFilter nitriteFilter = (NitriteFilter)Filter.and(filters);
        nitriteFilter.setObjectFilter(true);
        return nitriteFilter;
    }

    @Generated
    public String getIdFieldName() {
        return this.idFieldName;
    }

    @Generated
    public String[] getFieldNames() {
        return this.fieldNames;
    }

    @Generated
    public Field getField() {
        return this.field;
    }

    @Generated
    public boolean isEmbedded() {
        return this.isEmbedded;
    }

    @Generated
    public void setIdFieldName(String idFieldName) {
        this.idFieldName = idFieldName;
    }

    @Generated
    public void setFieldNames(String[] fieldNames) {
        this.fieldNames = fieldNames;
    }

    @Generated
    public void setField(Field field) {
        this.field = field;
    }

    @Generated
    public void setEmbedded(boolean isEmbedded) {
        this.isEmbedded = isEmbedded;
    }
}

