/*
 * Decompiled with CFR 0.152.
 */
package org.dizitart.no2.migration.commands;

import java.util.Collection;
import lombok.Generated;
import org.dizitart.no2.Nitrite;
import org.dizitart.no2.collection.Document;
import org.dizitart.no2.collection.NitriteId;
import org.dizitart.no2.collection.operation.IndexManager;
import org.dizitart.no2.common.Fields;
import org.dizitart.no2.common.tuples.Pair;
import org.dizitart.no2.index.IndexDescriptor;
import org.dizitart.no2.migration.commands.BaseCommand;

public class RenameField
extends BaseCommand {
    private final String collectionName;
    private final String oldName;
    private final String newName;

    @Override
    public void execute(Nitrite nitrite) {
        this.initialize(nitrite, this.collectionName);
        try (IndexManager indexManager = new IndexManager(this.oldName, nitrite.getConfig());){
            Fields oldField = Fields.withNames(this.oldName);
            Collection<IndexDescriptor> matchingIndexDescriptors = indexManager.findMatchingIndexDescriptors(oldField);
            for (Pair pair : this.nitriteMap.entries()) {
                Document document = (Document)pair.getSecond();
                if (!document.containsKey(this.oldName)) continue;
                Object value = document.get(this.oldName);
                document.put(this.newName, value);
                document.remove(this.oldName);
                this.nitriteMap.put((NitriteId)pair.getFirst(), document);
            }
            if (!matchingIndexDescriptors.isEmpty()) {
                for (IndexDescriptor indexDescriptor : matchingIndexDescriptors) {
                    String indexType = indexDescriptor.getIndexType();
                    Fields oldIndexFields = indexDescriptor.getFields();
                    Fields newIndexFields = this.getNewIndexFields(oldIndexFields, this.oldName, this.newName);
                    this.operations.dropIndex(indexDescriptor.getFields());
                    this.operations.createIndex(newIndexFields, indexType);
                }
            }
        }
    }

    private Fields getNewIndexFields(Fields oldIndexFields, String oldName, String newName) {
        Fields newIndexFields = new Fields();
        for (String fieldName : oldIndexFields.getFieldNames()) {
            if (fieldName.equals(oldName)) {
                newIndexFields.addField(newName);
                continue;
            }
            newIndexFields.addField(fieldName);
        }
        return newIndexFields;
    }

    @Generated
    public RenameField(String collectionName, String oldName, String newName) {
        this.collectionName = collectionName;
        this.oldName = oldName;
        this.newName = newName;
    }
}

