/*
 * Decompiled with CFR 0.152.
 */
package org.dizitart.no2.migration.commands;

import java.util.Collection;
import lombok.Generated;
import org.dizitart.no2.Nitrite;
import org.dizitart.no2.collection.Document;
import org.dizitart.no2.collection.NitriteId;
import org.dizitart.no2.collection.operation.CollectionOperations;
import org.dizitart.no2.collection.operation.IndexManager;
import org.dizitart.no2.common.Fields;
import org.dizitart.no2.common.tuples.Pair;
import org.dizitart.no2.index.IndexDescriptor;
import org.dizitart.no2.migration.commands.BaseCommand;
import org.dizitart.no2.store.NitriteMap;

public class Rename
extends BaseCommand {
    private final String oldName;
    private final String newName;

    @Override
    public void execute(Nitrite nitrite) {
        this.initialize(nitrite, this.oldName);
        NitriteMap<NitriteId, Document> newMap = this.nitriteStore.openMap(this.newName, NitriteId.class, Document.class);
        try (CollectionOperations newOperations = new CollectionOperations(this.newName, newMap, nitrite.getConfig(), null);){
            for (Pair pair : this.nitriteMap.entries()) {
                newMap.put((NitriteId)pair.getFirst(), (Document)pair.getSecond());
            }
            try (IndexManager indexManager = new IndexManager(this.oldName, nitrite.getConfig());){
                Collection<IndexDescriptor> collection = indexManager.getIndexDescriptors();
                for (IndexDescriptor indexDescriptor : collection) {
                    Fields field = indexDescriptor.getFields();
                    String indexType = indexDescriptor.getIndexType();
                    newOperations.createIndex(field, indexType);
                }
            }
        }
        this.operations.dropCollection();
    }

    @Generated
    public Rename(String oldName, String newName) {
        this.oldName = oldName;
        this.newName = newName;
    }
}

