/*
 * Decompiled with CFR 0.152.
 */
package org.dizitart.no2.migration;

import java.util.List;
import org.dizitart.no2.common.Fields;
import org.dizitart.no2.common.tuples.Pair;
import org.dizitart.no2.common.tuples.Quartet;
import org.dizitart.no2.common.tuples.Triplet;
import org.dizitart.no2.migration.Generator;
import org.dizitart.no2.migration.Instruction;
import org.dizitart.no2.migration.InstructionType;
import org.dizitart.no2.migration.MigrationStep;
import org.dizitart.no2.migration.TypeConverter;

public interface RepositoryInstruction
extends Instruction {
    default public RepositoryInstruction renameRepository(final String entityName, final String key) {
        MigrationStep migrationStep = new MigrationStep();
        migrationStep.setInstructionType(InstructionType.RenameRepository);
        migrationStep.setArguments(new Quartet<String, String, String, String>(this.entityName(), this.key(), entityName, key));
        this.addStep(migrationStep);
        final RepositoryInstruction parent = this;
        return new RepositoryInstruction(){

            @Override
            public String entityName() {
                return entityName;
            }

            @Override
            public String key() {
                return key;
            }

            @Override
            public void addStep(MigrationStep step) {
                parent.addStep(step);
            }
        };
    }

    default public <T> RepositoryInstruction addField(String fieldName) {
        return this.addField(fieldName, null);
    }

    default public <T> RepositoryInstruction addField(String fieldName, T defaultValue) {
        MigrationStep migrationStep = new MigrationStep();
        migrationStep.setInstructionType(InstructionType.RepositoryAddField);
        migrationStep.setArguments(new Quartet<String, String, String, T>(this.entityName(), this.key(), fieldName, defaultValue));
        this.addStep(migrationStep);
        return this;
    }

    default public <T> RepositoryInstruction addField(String fieldName, Generator<T> generator) {
        MigrationStep migrationStep = new MigrationStep();
        migrationStep.setInstructionType(InstructionType.RepositoryAddField);
        migrationStep.setArguments(new Quartet<String, String, String, Generator<T>>(this.entityName(), this.key(), fieldName, generator));
        this.addStep(migrationStep);
        return this;
    }

    default public RepositoryInstruction renameField(String oldName, String newName) {
        MigrationStep migrationStep = new MigrationStep();
        migrationStep.setInstructionType(InstructionType.RepositoryRenameField);
        migrationStep.setArguments(new Quartet<String, String, String, String>(this.entityName(), this.key(), oldName, newName));
        this.addStep(migrationStep);
        return this;
    }

    default public RepositoryInstruction deleteField(String fieldName) {
        MigrationStep migrationStep = new MigrationStep();
        migrationStep.setInstructionType(InstructionType.RepositoryDeleteField);
        migrationStep.setArguments(new Triplet<String, String, String>(this.entityName(), this.key(), fieldName));
        this.addStep(migrationStep);
        return this;
    }

    default public RepositoryInstruction changeDataType(String fieldName, TypeConverter<?, ?> converter) {
        MigrationStep migrationStep = new MigrationStep();
        migrationStep.setInstructionType(InstructionType.RepositoryChangeDataType);
        migrationStep.setArguments(new Quartet(this.entityName(), this.key(), fieldName, converter));
        this.addStep(migrationStep);
        return this;
    }

    default public RepositoryInstruction changeIdField(List<String> oldFieldNames, List<String> newFieldNames) {
        Fields oldFields = Fields.withNames(oldFieldNames.toArray(new String[0]));
        Fields newFields = Fields.withNames(newFieldNames.toArray(new String[0]));
        return this.changeIdField(oldFields, newFields);
    }

    default public RepositoryInstruction changeIdField(Fields oldField, Fields newField) {
        MigrationStep migrationStep = new MigrationStep();
        migrationStep.setInstructionType(InstructionType.RepositoryChangeIdField);
        migrationStep.setArguments(new Quartet<String, String, Fields, Fields>(this.entityName(), this.key(), oldField, newField));
        this.addStep(migrationStep);
        return this;
    }

    default public RepositoryInstruction dropIndex(String ... fieldNames) {
        Fields fields = Fields.withNames(fieldNames);
        MigrationStep migrationStep = new MigrationStep();
        migrationStep.setInstructionType(InstructionType.RepositoryDropIndex);
        migrationStep.setArguments(new Triplet<String, String, Fields>(this.entityName(), this.key(), fields));
        this.addStep(migrationStep);
        return this;
    }

    default public RepositoryInstruction dropAllIndices() {
        MigrationStep migrationStep = new MigrationStep();
        migrationStep.setInstructionType(InstructionType.RepositoryDropIndices);
        migrationStep.setArguments(new Pair<String, String>(this.entityName(), this.key()));
        this.addStep(migrationStep);
        return this;
    }

    default public RepositoryInstruction createIndex(String indexType, String ... fieldNames) {
        Fields fields = Fields.withNames(fieldNames);
        MigrationStep migrationStep = new MigrationStep();
        migrationStep.setInstructionType(InstructionType.RepositoryCreateIndex);
        migrationStep.setArguments(new Quartet<String, String, Fields, String>(this.entityName(), this.key(), fields, indexType));
        this.addStep(migrationStep);
        return this;
    }

    public String entityName();

    public String key();
}

