/*
 * Decompiled with CFR 0.152.
 */
package org.dizitart.no2.migration;

import java.util.LinkedList;
import java.util.Queue;
import lombok.Generated;
import org.dizitart.no2.migration.InstructionSet;
import org.dizitart.no2.migration.MigrationStep;
import org.dizitart.no2.migration.NitriteInstructionSet;

public abstract class Migration {
    private final Queue<MigrationStep> migrationSteps;
    private final Integer fromVersion;
    private final Integer toVersion;
    private boolean executed = false;

    public Migration(Integer fromVersion, Integer toVersion) {
        this.fromVersion = fromVersion;
        this.toVersion = toVersion;
        this.migrationSteps = new LinkedList<MigrationStep>();
    }

    public abstract void migrate(InstructionSet var1);

    public Queue<MigrationStep> steps() {
        if (!this.executed) {
            this.execute();
        }
        return this.migrationSteps;
    }

    private void execute() {
        NitriteInstructionSet instruction = new NitriteInstructionSet(this.migrationSteps);
        this.migrate(instruction);
        this.executed = true;
    }

    @Generated
    public Integer getFromVersion() {
        return this.fromVersion;
    }

    @Generated
    public Integer getToVersion() {
        return this.toVersion;
    }
}

