/*
 * Decompiled with CFR 0.152.
 */
package org.dizitart.no2.index;

import java.util.LinkedHashSet;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.dizitart.no2.collection.FindPlan;
import org.dizitart.no2.collection.NitriteId;
import org.dizitart.no2.common.FieldValues;
import org.dizitart.no2.common.util.ValidationUtils;
import org.dizitart.no2.exceptions.UniqueConstraintException;
import org.dizitart.no2.exceptions.ValidationException;
import org.dizitart.no2.index.IndexDescriptor;

public interface NitriteIndex {
    public IndexDescriptor getIndexDescriptor();

    public void write(FieldValues var1);

    public void remove(FieldValues var1);

    public void drop();

    public LinkedHashSet<NitriteId> findNitriteIds(FindPlan var1);

    default public boolean isUnique() {
        return this.getIndexDescriptor().getIndexType().equalsIgnoreCase("Unique");
    }

    default public void validateIndexField(Object value, String field) {
        if (value == null) {
            return;
        }
        if (value instanceof Iterable) {
            ValidationUtils.validateIterableIndexField((Iterable)value, field);
        } else if (value.getClass().isArray()) {
            ValidationUtils.validateArrayIndexField(value, field);
        } else if (!(value instanceof Comparable)) {
            throw new ValidationException("Index field " + field + " must be a comparable type");
        }
    }

    default public List<NitriteId> addNitriteIds(List<NitriteId> nitriteIds, FieldValues fieldValues) {
        if (nitriteIds == null) {
            nitriteIds = new CopyOnWriteArrayList<NitriteId>();
        }
        if (this.isUnique() && nitriteIds.size() == 1) {
            throw new UniqueConstraintException("Unique key constraint violation for " + fieldValues.getFields());
        }
        nitriteIds.add(fieldValues.getNitriteId());
        return nitriteIds;
    }

    default public List<NitriteId> removeNitriteIds(List<NitriteId> nitriteIds, FieldValues fieldValues) {
        if (nitriteIds != null && !nitriteIds.isEmpty()) {
            nitriteIds.remove(fieldValues.getNitriteId());
        }
        return nitriteIds;
    }
}

