/*
 * Decompiled with CFR 0.152.
 */
package org.dizitart.no2.filters;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.dizitart.no2.collection.Document;
import org.dizitart.no2.collection.NitriteId;
import org.dizitart.no2.common.tuples.Pair;
import org.dizitart.no2.exceptions.FilterException;
import org.dizitart.no2.filters.FieldBasedFilter;

class RegexFilter
extends FieldBasedFilter {
    private final Pattern pattern;

    RegexFilter(String field, String value) {
        super(field, value);
        this.pattern = Pattern.compile(value);
    }

    @Override
    public boolean apply(Pair<NitriteId, Document> element) {
        Document document = element.getSecond();
        Object fieldValue = document.get(this.getField());
        if (fieldValue != null) {
            if (fieldValue instanceof String) {
                Matcher matcher = this.pattern.matcher((String)fieldValue);
                if (matcher.find()) {
                    return true;
                }
                matcher.reset();
            } else {
                throw new FilterException(this.getField() + " does not contain string value");
            }
        }
        return false;
    }

    @Override
    public String toString() {
        return "(" + this.getField() + " regex " + this.getValue() + ")";
    }
}

