/*
 * Decompiled with CFR 0.152.
 */
package org.dizitart.no2.filters;

import java.util.ArrayList;
import java.util.List;
import org.dizitart.no2.collection.Document;
import org.dizitart.no2.collection.NitriteId;
import org.dizitart.no2.common.tuples.Pair;
import org.dizitart.no2.common.util.Comparables;
import org.dizitart.no2.common.util.Numbers;
import org.dizitart.no2.exceptions.FilterException;
import org.dizitart.no2.filters.SortingAwareFilter;
import org.dizitart.no2.index.IndexMap;

class GreaterThanFilter
extends SortingAwareFilter {
    protected GreaterThanFilter(String field, Comparable<?> value) {
        super(field, value);
    }

    @Override
    public boolean apply(Pair<NitriteId, Document> element) {
        Comparable comparable = this.getComparable();
        Document document = element.getSecond();
        Object fieldValue = document.get(this.getField());
        if (fieldValue != null) {
            if (fieldValue instanceof Number && comparable instanceof Number) {
                return Numbers.compare((Number)fieldValue, (Number)((Object)comparable)) > 0;
            }
            if (fieldValue instanceof Comparable) {
                Comparable arg = (Comparable)fieldValue;
                return arg.compareTo(comparable) > 0;
            }
            throw new FilterException(fieldValue + " is not comparable");
        }
        return false;
    }

    @Override
    public List<?> applyOnIndex(IndexMap indexMap) {
        Comparable comparable = this.getComparable();
        ArrayList subMaps = new ArrayList();
        ArrayList<NitriteId> nitriteIds = new ArrayList<NitriteId>();
        if (this.isReverseScan()) {
            Object lastKey = indexMap.lastKey();
            while (lastKey != null && Comparables.compare(lastKey, comparable) > 0) {
                Object value = indexMap.get((Comparable<?>)lastKey);
                this.processIndexValue(value, subMaps, nitriteIds);
                lastKey = indexMap.lowerKey(lastKey);
            }
        } else {
            Comparable higherKey = indexMap.higherKey(comparable);
            while (higherKey != null) {
                Object value = indexMap.get(higherKey);
                this.processIndexValue(value, subMaps, nitriteIds);
                higherKey = indexMap.higherKey(higherKey);
            }
        }
        if (!subMaps.isEmpty()) {
            return subMaps;
        }
        return nitriteIds;
    }

    @Override
    public String toString() {
        return "(" + this.getField() + " > " + this.getValue() + ")";
    }
}

