/*
 * Decompiled with CFR 0.152.
 */
package org.dizitart.no2.filters;

import org.dizitart.no2.collection.Document;
import org.dizitart.no2.collection.NitriteId;
import org.dizitart.no2.common.tuples.Pair;
import org.dizitart.no2.common.util.ValidationUtils;
import org.dizitart.no2.exceptions.FilterException;
import org.dizitart.no2.filters.AndFilter;
import org.dizitart.no2.filters.EqualsFilter;
import org.dizitart.no2.filters.NotFilter;
import org.dizitart.no2.filters.OrFilter;

public interface Filter {
    public static final Filter ALL = element -> true;

    public static Filter byId(NitriteId nitriteId) {
        return new EqualsFilter("_id", nitriteId.getIdValue());
    }

    public static Filter and(Filter ... filters) {
        ValidationUtils.notEmpty(filters, "At least two filters must be specified");
        if (filters.length < 2) {
            throw new FilterException("At least two filters must be specified");
        }
        return new AndFilter(filters);
    }

    public static Filter or(Filter ... filters) {
        ValidationUtils.notEmpty(filters, "At least two filters must be specified");
        if (filters.length < 2) {
            throw new FilterException("At least two filters must be specified");
        }
        return new OrFilter(filters);
    }

    public boolean apply(Pair<NitriteId, Document> var1);

    default public Filter not() {
        return new NotFilter(this);
    }
}

