/*
 * Decompiled with CFR 0.152.
 */
package org.dizitart.no2.filters;

import java.util.ArrayList;
import java.util.List;
import org.dizitart.no2.collection.Document;
import org.dizitart.no2.collection.NitriteId;
import org.dizitart.no2.common.tuples.Pair;
import org.dizitart.no2.common.util.ObjectUtils;
import org.dizitart.no2.filters.ComparableFilter;
import org.dizitart.no2.index.IndexMap;

public class EqualsFilter
extends ComparableFilter {
    EqualsFilter(String field, Object value) {
        super(field, value);
    }

    @Override
    public boolean apply(Pair<NitriteId, Document> element) {
        Document document = element.getSecond();
        Object fieldValue = document.get(this.getField());
        return ObjectUtils.deepEquals(fieldValue, this.getValue());
    }

    @Override
    public List<?> applyOnIndex(IndexMap indexMap) {
        Object value = indexMap.get((Comparable)this.getValue());
        if (value == null) {
            return new ArrayList();
        }
        if (value instanceof List) {
            return (List)value;
        }
        ArrayList<Object> result = new ArrayList<Object>();
        result.add(value);
        return result;
    }

    @Override
    public String toString() {
        return "(" + this.getField() + " == " + this.getValue() + ")";
    }
}

