/*
 * Decompiled with CFR 0.152.
 */
package org.dizitart.no2.common.util;

import java.math.BigDecimal;
import java.math.BigInteger;
import org.dizitart.no2.exceptions.ValidationException;

public class Numbers {
    private Numbers() {
    }

    public static int compare(Number x, Number y) {
        if (Numbers.isSpecial(x) || Numbers.isSpecial(y)) {
            return Double.compare(x.doubleValue(), y.doubleValue());
        }
        return Numbers.toBigDecimal(x).compareTo(Numbers.toBigDecimal(y));
    }

    private static boolean isSpecial(Number number) {
        boolean specialDouble = number instanceof Double && (Double.isNaN((Double)number) || Double.isInfinite((Double)number));
        boolean specialFloat = number instanceof Float && (Float.isNaN(((Float)number).floatValue()) || Float.isInfinite(((Float)number).floatValue()));
        return specialDouble || specialFloat;
    }

    private static BigDecimal toBigDecimal(Number number) {
        if (number instanceof BigDecimal) {
            return (BigDecimal)number;
        }
        if (number instanceof BigInteger) {
            return new BigDecimal((BigInteger)number);
        }
        if (number instanceof Byte || number instanceof Short || number instanceof Integer || number instanceof Long) {
            return new BigDecimal(number.longValue());
        }
        if (number instanceof Float || number instanceof Double) {
            return BigDecimal.valueOf(number.doubleValue());
        }
        try {
            return new BigDecimal(number.toString());
        }
        catch (NumberFormatException e) {
            throw new ValidationException("The given number (\"" + number + "\" of class " + number.getClass().getName() + ") does not have a parsable string representation", e);
        }
    }
}

