/*
 * Decompiled with CFR 0.152.
 */
package org.dizitart.no2.common.streams;

import java.util.Iterator;
import java.util.Set;
import org.dizitart.no2.collection.Document;
import org.dizitart.no2.collection.NitriteId;
import org.dizitart.no2.common.RecordStream;
import org.dizitart.no2.common.tuples.Pair;
import org.dizitart.no2.store.NitriteMap;

public class IndexedStream
implements RecordStream<Pair<NitriteId, Document>> {
    private final NitriteMap<NitriteId, Document> nitriteMap;
    private final Set<NitriteId> nitriteIds;

    public IndexedStream(Set<NitriteId> nitriteIds, NitriteMap<NitriteId, Document> nitriteMap) {
        this.nitriteIds = nitriteIds;
        this.nitriteMap = nitriteMap;
    }

    @Override
    public Iterator<Pair<NitriteId, Document>> iterator() {
        return new IndexedStreamIterator(this.nitriteIds.iterator(), this.nitriteMap);
    }

    private static class IndexedStreamIterator
    implements Iterator<Pair<NitriteId, Document>> {
        private final Iterator<NitriteId> iterator;
        private final NitriteMap<NitriteId, Document> nitriteMap;

        IndexedStreamIterator(Iterator<NitriteId> iterator, NitriteMap<NitriteId, Document> nitriteMap) {
            this.iterator = iterator;
            this.nitriteMap = nitriteMap;
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public Pair<NitriteId, Document> next() {
            NitriteId id = this.iterator.next();
            Document document = this.nitriteMap.get(id);
            return new Pair<NitriteId, Document>(id, document);
        }
    }
}

