/*
 * Decompiled with CFR 0.152.
 */
package org.dizitart.no2.common.streams;

import java.text.Collator;
import java.util.Comparator;
import java.util.List;
import org.dizitart.no2.collection.Document;
import org.dizitart.no2.collection.NitriteId;
import org.dizitart.no2.common.DBNull;
import org.dizitart.no2.common.SortOrder;
import org.dizitart.no2.common.tuples.Pair;
import org.dizitart.no2.exceptions.InvalidOperationException;

public class DocumentSorter
implements Comparator<Pair<NitriteId, Document>> {
    private final Collator collator;
    private final List<Pair<String, SortOrder>> sortOrder;

    public DocumentSorter(Collator collator, List<Pair<String, SortOrder>> sortOrder) {
        this.collator = collator;
        this.sortOrder = sortOrder;
    }

    @Override
    public int compare(Pair<NitriteId, Document> pair1, Pair<NitriteId, Document> pair2) {
        if (this.sortOrder != null && !this.sortOrder.isEmpty()) {
            for (Pair<String, SortOrder> pair : this.sortOrder) {
                int result;
                Document doc1 = pair1.getSecond();
                Document doc2 = pair2.getSecond();
                Object value1 = doc1.get(pair.getFirst());
                Object value2 = doc2.get(pair.getFirst());
                if ((value1 == null || value1 instanceof DBNull) && value2 != null) {
                    result = -1;
                } else if (value1 != null && (value2 == null || value2 instanceof DBNull)) {
                    result = 1;
                } else if (value1 == null) {
                    result = -1;
                } else {
                    if (!(value1 instanceof Comparable) || !(value2 instanceof Comparable)) {
                        throw new InvalidOperationException("Cannot compare " + value1.getClass() + " and " + value2.getClass());
                    }
                    Comparable c1 = (Comparable)value1;
                    Comparable c2 = (Comparable)value2;
                    result = c1 instanceof String && c2 instanceof String && this.collator != null ? this.collator.compare(c1, c2) : c1.compareTo(c2);
                }
                if (pair.getSecond() == SortOrder.Descending) {
                    result *= -1;
                }
                if (result == 0) continue;
                return result;
            }
        }
        return 0;
    }
}

