/*
 * Decompiled with CFR 0.152.
 */
package org.dizitart.no2.common.streams;

import java.util.Collections;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.dizitart.no2.common.RecordStream;
import org.dizitart.no2.common.tuples.Pair;
import org.dizitart.no2.exceptions.ValidationException;

public class BoundedStream<Key, Value>
implements RecordStream<Pair<Key, Value>> {
    private final RecordStream<Pair<Key, Value>> recordStream;
    private final long skip;
    private final long limit;

    public BoundedStream(Long skip, Long limit, RecordStream<Pair<Key, Value>> recordStream) {
        this.skip = skip;
        this.limit = limit;
        if (skip < 0L) {
            throw new ValidationException("skip parameter must not be negative");
        }
        if (limit < 0L) {
            throw new ValidationException("limit parameter must not be negative");
        }
        this.recordStream = recordStream;
    }

    @Override
    public Iterator<Pair<Key, Value>> iterator() {
        Iterator iterator = this.recordStream == null ? Collections.emptyIterator() : this.recordStream.iterator();
        return new BoundedIterator<Pair<Key, Value>>(iterator, this.skip, this.limit);
    }

    private static class BoundedIterator<T>
    implements Iterator<T> {
        private final Iterator<? extends T> iterator;
        private final long skip;
        private final long limit;
        private long pos;

        public BoundedIterator(Iterator<? extends T> iterator, long skip, long limit) {
            if (iterator == null) {
                throw new ValidationException("Iterator must not be null");
            }
            if (skip < 0L) {
                throw new ValidationException("skip parameter must not be negative");
            }
            if (limit < 0L) {
                throw new ValidationException("limit parameter must not be negative");
            }
            this.iterator = iterator;
            this.skip = skip;
            this.limit = limit;
            this.pos = 0L;
            this.initialize();
        }

        private void initialize() {
            while (this.pos < this.skip && this.iterator.hasNext()) {
                this.iterator.next();
                ++this.pos;
            }
        }

        @Override
        public boolean hasNext() {
            if (this.checkBounds()) {
                return false;
            }
            return this.iterator.hasNext();
        }

        private boolean checkBounds() {
            return this.pos - this.skip + 1L > this.limit;
        }

        @Override
        public T next() {
            if (this.checkBounds()) {
                throw new NoSuchElementException();
            }
            T next = this.iterator.next();
            ++this.pos;
            return next;
        }

        @Override
        public void remove() {
            if (this.pos <= this.skip) {
                throw new IllegalStateException("remove() cannot be called before calling next()");
            }
            this.iterator.remove();
        }
    }
}

