/*
 * Decompiled with CFR 0.152.
 */
package org.dizitart.no2.collection;

import java.text.Collator;
import lombok.Generated;
import org.dizitart.no2.common.SortOrder;
import org.dizitart.no2.common.SortableFields;

public class FindOptions {
    private SortableFields orderBy;
    private Long skip;
    private Long limit;
    private boolean distinct = false;
    private Collator collator = Collator.getInstance();

    public static FindOptions orderBy(String fieldName, SortOrder sortOrder) {
        SortableFields fields = new SortableFields();
        fields.addField(fieldName, sortOrder);
        FindOptions findOptions = new FindOptions();
        findOptions.orderBy(fields);
        return findOptions;
    }

    public static FindOptions skipBy(long skip) {
        FindOptions findOptions = new FindOptions();
        findOptions.skip(skip);
        return findOptions;
    }

    public static FindOptions limitBy(long limit) {
        FindOptions findOptions = new FindOptions();
        findOptions.limit(limit);
        return findOptions;
    }

    public static FindOptions withDistinct() {
        FindOptions findOptions = new FindOptions();
        findOptions.distinct(true);
        return findOptions;
    }

    public FindOptions skip(Long skip) {
        this.skip = skip;
        return this;
    }

    public FindOptions skip(Integer skip) {
        this.skip = skip == null ? null : Long.valueOf(skip.intValue());
        return this;
    }

    public FindOptions limit(Long limit) {
        this.limit = limit;
        return this;
    }

    public FindOptions limit(Integer limit) {
        this.limit = limit == null ? null : Long.valueOf(limit.intValue());
        return this;
    }

    public FindOptions thenOrderBy(String fieldName, SortOrder sortOrder) {
        if (this.orderBy != null) {
            this.orderBy.addField(fieldName, sortOrder);
        } else {
            SortableFields fields = new SortableFields();
            fields.addField(fieldName, sortOrder);
            this.orderBy = fields;
        }
        return this;
    }

    public FindOptions withDistinct(boolean distinct) {
        this.distinct = distinct;
        return this;
    }

    @Generated
    public SortableFields orderBy() {
        return this.orderBy;
    }

    @Generated
    public Long skip() {
        return this.skip;
    }

    @Generated
    public Long limit() {
        return this.limit;
    }

    @Generated
    public boolean distinct() {
        return this.distinct;
    }

    @Generated
    public Collator collator() {
        return this.collator;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FindOptions)) {
            return false;
        }
        FindOptions other = (FindOptions)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.distinct() != other.distinct()) {
            return false;
        }
        Long this$skip = this.skip();
        Long other$skip = other.skip();
        if (this$skip == null ? other$skip != null : !((Object)this$skip).equals(other$skip)) {
            return false;
        }
        Long this$limit = this.limit();
        Long other$limit = other.limit();
        if (this$limit == null ? other$limit != null : !((Object)this$limit).equals(other$limit)) {
            return false;
        }
        SortableFields this$orderBy = this.orderBy();
        SortableFields other$orderBy = other.orderBy();
        if (this$orderBy == null ? other$orderBy != null : !((Object)this$orderBy).equals(other$orderBy)) {
            return false;
        }
        Collator this$collator = this.collator();
        Collator other$collator = other.collator();
        return !(this$collator == null ? other$collator != null : !((Object)this$collator).equals(other$collator));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof FindOptions;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.distinct() ? 79 : 97);
        Long $skip = this.skip();
        result = result * 59 + ($skip == null ? 43 : ((Object)$skip).hashCode());
        Long $limit = this.limit();
        result = result * 59 + ($limit == null ? 43 : ((Object)$limit).hashCode());
        SortableFields $orderBy = this.orderBy();
        result = result * 59 + ($orderBy == null ? 43 : ((Object)$orderBy).hashCode());
        Collator $collator = this.collator();
        result = result * 59 + ($collator == null ? 43 : ((Object)$collator).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "FindOptions(orderBy=" + this.orderBy() + ", skip=" + this.skip() + ", limit=" + this.limit() + ", distinct=" + this.distinct() + ", collator=" + this.collator() + ")";
    }

    @Generated
    FindOptions orderBy(SortableFields orderBy) {
        this.orderBy = orderBy;
        return this;
    }

    @Generated
    FindOptions distinct(boolean distinct) {
        this.distinct = distinct;
        return this;
    }

    @Generated
    public FindOptions collator(Collator collator) {
        this.collator = collator;
        return this;
    }
}

