/*
 * Decompiled with CFR 0.152.
 */
package org.dizitart.no2.sync;

import java.util.Collection;
import java.util.List;
import org.dizitart.no2.Document;
import org.dizitart.no2.NitriteCollection;
import org.dizitart.no2.event.ChangeInfo;
import org.dizitart.no2.event.ChangeListener;
import org.dizitart.no2.event.ChangeType;
import org.dizitart.no2.event.ChangedItem;
import org.dizitart.no2.sync.CollectionReplicator;
import org.dizitart.no2.util.Iterables;
import org.dizitart.no2.util.StringUtils;

class RemoveLogWriter
implements ChangeListener {
    private final NitriteCollection changeLogRepository;
    private String collection;

    RemoveLogWriter(NitriteCollection changeLogRepository) {
        this.changeLogRepository = changeLogRepository;
    }

    @Override
    public void onChange(ChangeInfo changeInfo) {
        String threadName = changeInfo.getOriginatingThread();
        if (!StringUtils.isNullOrEmpty(threadName) && !threadName.contains(CollectionReplicator.class.getSimpleName())) {
            ChangeType action = changeInfo.getChangeType();
            Collection<ChangedItem> changedItems = changeInfo.getChangedItems();
            if (action == ChangeType.REMOVE) {
                this.queueRemovedItems(Iterables.toList(changedItems));
            }
        }
    }

    private void queueRemovedItems(List<ChangedItem> changedItems) {
        for (ChangedItem item : changedItems) {
            Document logEntry = Document.createDocument("collection", this.collection).put("deleteTime", (Object)item.getChangeTimestamp()).put("deletedItem", (Object)item.getDocument());
            this.changeLogRepository.insert(logEntry, new Document[0]);
        }
    }

    public String getCollection() {
        return this.collection;
    }

    public void setCollection(String collection) {
        this.collection = collection;
    }
}

