/*
 * Decompiled with CFR 0.152.
 */
package org.dizitart.no2.internals;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.dizitart.no2.Cursor;
import org.dizitart.no2.Document;
import org.dizitart.no2.KeyValuePair;
import org.dizitart.no2.Lookup;
import org.dizitart.no2.NitriteId;
import org.dizitart.no2.RecordIterable;
import org.dizitart.no2.exceptions.ErrorMessage;
import org.dizitart.no2.exceptions.InvalidOperationException;
import org.dizitart.no2.exceptions.ValidationException;
import org.dizitart.no2.internals.FindResult;
import org.dizitart.no2.internals.JoinedDocumentIterable;
import org.dizitart.no2.internals.ProjectedDocumentIterable;
import org.dizitart.no2.store.NitriteMap;
import org.dizitart.no2.util.Iterables;

class DocumentCursor
implements Cursor {
    private final Set<NitriteId> resultSet;
    private final NitriteMap<NitriteId, Document> underlyingMap;
    private boolean hasMore;
    private int totalCount;
    private FindResult findResult;

    DocumentCursor(FindResult findResult) {
        this.resultSet = findResult.getIdSet() != null ? Collections.unmodifiableSet(findResult.getIdSet()) : Collections.unmodifiableSet(new TreeSet());
        this.underlyingMap = findResult.getUnderlyingMap();
        this.hasMore = findResult.isHasMore();
        this.totalCount = findResult.getTotalCount();
        this.findResult = findResult;
    }

    @Override
    public RecordIterable<Document> project(Document projection) {
        this.validateProjection(projection);
        return new ProjectedDocumentIterable(projection, this.findResult);
    }

    @Override
    public RecordIterable<Document> join(Cursor cursor, Lookup lookup) {
        return new JoinedDocumentIterable(this.findResult, cursor, lookup);
    }

    @Override
    public Set<NitriteId> idSet() {
        return this.resultSet;
    }

    @Override
    public Iterator<Document> iterator() {
        return new DocumentCursorIterator();
    }

    @Override
    public boolean hasMore() {
        return this.hasMore;
    }

    @Override
    public int size() {
        return this.resultSet.size();
    }

    @Override
    public int totalCount() {
        return this.totalCount;
    }

    @Override
    public Document firstOrDefault() {
        return Iterables.firstOrDefault(this);
    }

    @Override
    public List<Document> toList() {
        return Iterables.toList(this);
    }

    private void validateProjection(Document projection) {
        for (KeyValuePair kvp : projection) {
            this.validateKeyValuePair(kvp);
        }
    }

    private void validateKeyValuePair(KeyValuePair kvp) {
        if (kvp.getValue() != null) {
            if (!(kvp.getValue() instanceof Document)) {
                throw new ValidationException(ErrorMessage.PROJECTION_WITH_NOT_NULL_VALUES);
            }
            this.validateProjection((Document)kvp.getValue());
        }
    }

    private class DocumentCursorIterator
    implements Iterator<Document> {
        private Iterator<NitriteId> iterator;

        DocumentCursorIterator() {
            this.iterator = DocumentCursor.this.resultSet.iterator();
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public Document next() {
            NitriteId next = this.iterator.next();
            Document document = (Document)DocumentCursor.this.underlyingMap.get(next);
            if (document != null) {
                return new Document(document);
            }
            return null;
        }

        @Override
        public void remove() {
            throw new InvalidOperationException(ErrorMessage.REMOVE_ON_DOCUMENT_ITERATOR_NOT_SUPPORTED);
        }
    }
}

