/*
 * Decompiled with CFR 0.152.
 */
package org.dizitart.no2.mvstore.compat.v1.mvstore.util;

import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import java.util.Vector;
import org.dizitart.no2.mvstore.compat.v1.mvstore.fs.FileUtils;
import org.dizitart.no2.mvstore.compat.v1.mvstore.util.StringUtils;
import org.h2.util.Utils;

public class SortedProperties
extends Properties {
    private static final long serialVersionUID = 1L;

    @Override
    public synchronized Enumeration<Object> keys() {
        Vector<String> var1 = new Vector<String>();
        for (Object var3 : this.keySet()) {
            var1.add(var3.toString());
        }
        Collections.sort(var1);
        return new Vector(var1).elements();
    }

    public static boolean getBooleanProperty(Properties var0, String var1, boolean var2) {
        try {
            return Utils.parseBoolean((String)var0.getProperty(var1, null), (boolean)var2, (boolean)true);
        }
        catch (IllegalArgumentException var4) {
            var4.printStackTrace();
            return var2;
        }
    }

    public static int getIntProperty(Properties var0, String var1, int var2) {
        String var3 = var0.getProperty(var1, Integer.toString(var2));
        try {
            return Integer.decode(var3);
        }
        catch (Exception var5) {
            var5.printStackTrace();
            return var2;
        }
    }

    public static String getStringProperty(Properties var0, String var1, String var2) {
        return var0.getProperty(var1, var2);
    }

    public static synchronized SortedProperties loadProperties(String var0) throws IOException {
        SortedProperties var1 = new SortedProperties();
        if (FileUtils.exists(var0)) {
            try (InputStream var2 = FileUtils.newInputStream(var0);){
                var1.load(var2);
            }
        }
        return var1;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void store(String var1) throws IOException {
        OutputStreamWriter var6;
        ByteArrayOutputStream var2 = new ByteArrayOutputStream();
        this.store(var2, (String)null);
        ByteArrayInputStream var3 = new ByteArrayInputStream(var2.toByteArray());
        InputStreamReader var4 = new InputStreamReader((InputStream)var3, StandardCharsets.ISO_8859_1);
        LineNumberReader var5 = new LineNumberReader(var4);
        try {
            var6 = new OutputStreamWriter(FileUtils.newOutputStream(var1, false));
        }
        catch (Exception var18) {
            throw new IOException(var18.toString(), var18);
        }
        try (PrintWriter var7 = new PrintWriter(new BufferedWriter(var6));){
            while (true) {
                String var9;
                if ((var9 = var5.readLine()) == null) {
                    return;
                }
                if (var9.startsWith("#")) continue;
                var7.print(var9 + "\n");
                continue;
                break;
            }
        }
    }

    public synchronized String toLines() {
        StringBuilder var1 = new StringBuilder();
        for (Map.Entry<Object, Object> var3 : new TreeMap<Object, Object>(this).entrySet()) {
            var1.append(var3.getKey()).append('=').append(var3.getValue()).append('\n');
        }
        return var1.toString();
    }

    public static SortedProperties fromLines(String var0) {
        SortedProperties var1 = new SortedProperties();
        for (String var5 : StringUtils.arraySplit(var0, '\n', true)) {
            int var6 = var5.indexOf(61);
            if (var6 <= 0) continue;
            var1.put(var5.substring(0, var6), var5.substring(var6 + 1));
        }
        return var1;
    }
}

