/*
 * Decompiled with CFR 0.152.
 */
package org.dizitart.no2.mvstore.compat.v1.mvstore.fs;

import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.List;
import org.dizitart.no2.mvstore.compat.v1.mvstore.fs.FilePath;

public class FileUtils {
    public static boolean exists(String var0) {
        return FilePath.get(var0).exists();
    }

    public static void createDirectory(String var0) {
        FilePath.get(var0).createDirectory();
    }

    public static boolean createFile(String var0) {
        return FilePath.get(var0).createFile();
    }

    public static void delete(String var0) {
        FilePath.get(var0).delete();
    }

    public static String toRealPath(String var0) {
        return FilePath.get(var0).toRealPath().toString();
    }

    public static String getParent(String var0) {
        FilePath var1 = FilePath.get(var0).getParent();
        return var1 == null ? null : var1.toString();
    }

    public static boolean isAbsolute(String var0) {
        return FilePath.get(var0).isAbsolute() || var0.startsWith(File.pathSeparator) || var0.startsWith("/");
    }

    public static void move(String var0, String var1) {
        FilePath.get(var0).moveTo(FilePath.get(var1), false);
    }

    public static void moveAtomicReplace(String var0, String var1) {
        FilePath.get(var0).moveTo(FilePath.get(var1), true);
    }

    public static String getName(String var0) {
        return FilePath.get(var0).getName();
    }

    public static List<String> newDirectoryStream(String var0) {
        List<FilePath> var1 = FilePath.get(var0).newDirectoryStream();
        int var2 = var1.size();
        ArrayList<String> var3 = new ArrayList<String>(var2);
        for (FilePath var5 : var1) {
            var3.add(var5.toString());
        }
        return var3;
    }

    public static long lastModified(String var0) {
        return FilePath.get(var0).lastModified();
    }

    public static long size(String var0) {
        return FilePath.get(var0).size();
    }

    public static boolean isDirectory(String var0) {
        return FilePath.get(var0).isDirectory();
    }

    public static FileChannel open(String var0, String var1) throws IOException {
        return FilePath.get(var0).open(var1);
    }

    public static InputStream newInputStream(String var0) throws IOException {
        return FilePath.get(var0).newInputStream();
    }

    public static OutputStream newOutputStream(String var0, boolean var1) throws IOException {
        return FilePath.get(var0).newOutputStream(var1);
    }

    public static boolean canWrite(String var0) {
        return FilePath.get(var0).canWrite();
    }

    public static boolean setReadOnly(String var0) {
        return FilePath.get(var0).setReadOnly();
    }

    public static String unwrap(String var0) {
        return FilePath.get(var0).unwrap().toString();
    }

    public static void deleteRecursive(String var0, boolean var1) {
        if (FileUtils.exists(var0)) {
            if (FileUtils.isDirectory(var0)) {
                for (String var3 : FileUtils.newDirectoryStream(var0)) {
                    FileUtils.deleteRecursive(var3, var1);
                }
            }
            if (var1) {
                FileUtils.tryDelete(var0);
            } else {
                FileUtils.delete(var0);
            }
        }
    }

    public static void createDirectories(String var0) {
        if (var0 != null) {
            if (FileUtils.exists(var0)) {
                if (!FileUtils.isDirectory(var0)) {
                    FileUtils.createDirectory(var0);
                }
            } else {
                String var1 = FileUtils.getParent(var0);
                FileUtils.createDirectories(var1);
                FileUtils.createDirectory(var0);
            }
        }
    }

    public static boolean tryDelete(String var0) {
        try {
            FilePath.get(var0).delete();
            return true;
        }
        catch (Exception var2) {
            return false;
        }
    }

    public static String createTempFile(String var0, String var1, boolean var2) throws IOException {
        return FilePath.get(var0).createTempFile(var1, var2).toString();
    }

    public static void readFully(FileChannel var0, ByteBuffer var1) throws IOException {
        do {
            int var2;
            if ((var2 = var0.read(var1)) >= 0) continue;
            throw new EOFException();
        } while (var1.remaining() > 0);
    }

    public static void writeFully(FileChannel var0, ByteBuffer var1) throws IOException {
        do {
            var0.write(var1);
        } while (var1.remaining() > 0);
    }
}

