/*
 * Decompiled with CFR 0.152.
 */
package org.dizitart.no2.mvstore.compat.v1.mvstore.fs;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.FileChannel;
import java.util.List;
import org.dizitart.no2.mvstore.compat.v1.mvstore.fs.FilePath;

public abstract class FilePathWrapper
extends FilePath {
    private FilePath base;

    @Override
    public FilePathWrapper getPath(String var1) {
        return this.create(var1, this.unwrap(var1));
    }

    public FilePathWrapper wrap(FilePath var1) {
        return var1 == null ? null : this.create(this.getPrefix() + var1.name, var1);
    }

    @Override
    public FilePath unwrap() {
        return this.unwrap(this.name);
    }

    private FilePathWrapper create(String var1, FilePath var2) {
        try {
            FilePathWrapper var3 = (FilePathWrapper)this.getClass().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            var3.name = var1;
            var3.base = var2;
            return var3;
        }
        catch (Exception var4) {
            throw new IllegalArgumentException("Path: " + var1, var4);
        }
    }

    protected String getPrefix() {
        return this.getScheme() + ":";
    }

    protected FilePath unwrap(String var1) {
        return FilePath.get(var1.substring(this.getScheme().length() + 1));
    }

    protected FilePath getBase() {
        return this.base;
    }

    @Override
    public boolean canWrite() {
        return this.base.canWrite();
    }

    @Override
    public void createDirectory() {
        this.base.createDirectory();
    }

    @Override
    public boolean createFile() {
        return this.base.createFile();
    }

    @Override
    public void delete() {
        this.base.delete();
    }

    @Override
    public boolean exists() {
        return this.base.exists();
    }

    @Override
    public FilePath getParent() {
        return this.wrap(this.base.getParent());
    }

    @Override
    public boolean isAbsolute() {
        return this.base.isAbsolute();
    }

    @Override
    public boolean isDirectory() {
        return this.base.isDirectory();
    }

    @Override
    public long lastModified() {
        return this.base.lastModified();
    }

    @Override
    public FilePath toRealPath() {
        return this.wrap(this.base.toRealPath());
    }

    @Override
    public List<FilePath> newDirectoryStream() {
        List<FilePath> var1 = this.base.newDirectoryStream();
        int var3 = var1.size();
        for (int var2 = 0; var2 < var3; ++var2) {
            var1.set(var2, this.wrap(var1.get(var2)));
        }
        return var1;
    }

    @Override
    public void moveTo(FilePath var1, boolean var2) {
        this.base.moveTo(((FilePathWrapper)var1).base, var2);
    }

    @Override
    public InputStream newInputStream() throws IOException {
        return this.base.newInputStream();
    }

    @Override
    public OutputStream newOutputStream(boolean var1) throws IOException {
        return this.base.newOutputStream(var1);
    }

    @Override
    public FileChannel open(String var1) throws IOException {
        return this.base.open(var1);
    }

    @Override
    public boolean setReadOnly() {
        return this.base.setReadOnly();
    }

    @Override
    public long size() {
        return this.base.size();
    }

    @Override
    public FilePath createTempFile(String var1, boolean var2) throws IOException {
        return this.wrap(this.base.createTempFile(var1, var2));
    }
}

