/*
 * Decompiled with CFR 0.152.
 */
package org.dizitart.no2.mvstore.compat.v1.mvstore.fs;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.NonWritableChannelException;
import org.dizitart.no2.mvstore.compat.v1.mvstore.fs.FileBase;

class FileNio
extends FileBase {
    private final String name;
    private final FileChannel channel;

    FileNio(String var1, String var2) throws IOException {
        this.name = var1;
        this.channel = new RandomAccessFile(var1, var2).getChannel();
    }

    @Override
    public void implCloseChannel() throws IOException {
        this.channel.close();
    }

    @Override
    public long position() throws IOException {
        return this.channel.position();
    }

    @Override
    public long size() throws IOException {
        return this.channel.size();
    }

    @Override
    public int read(ByteBuffer var1) throws IOException {
        return this.channel.read(var1);
    }

    @Override
    public FileChannel position(long var1) throws IOException {
        this.channel.position(var1);
        return this;
    }

    @Override
    public int read(ByteBuffer var1, long var2) throws IOException {
        return this.channel.read(var1, var2);
    }

    @Override
    public int write(ByteBuffer var1, long var2) throws IOException {
        return this.channel.write(var1, var2);
    }

    @Override
    public FileChannel truncate(long var1) throws IOException {
        long var3 = this.channel.size();
        if (var1 < var3) {
            long var5 = this.channel.position();
            this.channel.truncate(var1);
            long var7 = this.channel.position();
            if (var5 < var1) {
                if (var7 != var5) {
                    this.channel.position(var5);
                }
            } else if (var7 > var1) {
                this.channel.position(var1);
            }
        }
        return this;
    }

    @Override
    public void force(boolean var1) throws IOException {
        this.channel.force(var1);
    }

    @Override
    public int write(ByteBuffer var1) throws IOException {
        try {
            return this.channel.write(var1);
        }
        catch (NonWritableChannelException var3) {
            throw new IOException("read only");
        }
    }

    @Override
    public synchronized FileLock tryLock(long var1, long var3, boolean var5) throws IOException {
        return this.channel.tryLock(var1, var3, var5);
    }

    public String toString() {
        return "nio:" + this.name;
    }
}

