/*
 * Decompiled with CFR 0.152.
 */
package org.dizitart.no2.mvstore.compat.v1.mvstore.fs;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.NonWritableChannelException;
import org.dizitart.no2.mvstore.compat.v1.mvstore.SysProperties;
import org.dizitart.no2.mvstore.compat.v1.mvstore.fs.FileBase;

class FileDisk
extends FileBase {
    private final RandomAccessFile file;
    private final String name;
    private final boolean readOnly;

    FileDisk(String var1, String var2) throws FileNotFoundException {
        this.file = new RandomAccessFile(var1, var2);
        this.name = var1;
        this.readOnly = var2.equals("r");
    }

    @Override
    public void force(boolean var1) throws IOException {
        String var2 = SysProperties.SYNC_METHOD;
        if (!"".equals(var2)) {
            if ("sync".equals(var2)) {
                this.file.getFD().sync();
            } else if ("force".equals(var2)) {
                this.file.getChannel().force(true);
            } else if ("forceFalse".equals(var2)) {
                this.file.getChannel().force(false);
            } else {
                this.file.getFD().sync();
            }
        }
    }

    @Override
    public FileChannel truncate(long var1) throws IOException {
        if (this.readOnly) {
            throw new NonWritableChannelException();
        }
        this.file.getChannel().truncate(var1);
        return this;
    }

    @Override
    public synchronized FileLock tryLock(long var1, long var3, boolean var5) throws IOException {
        return this.file.getChannel().tryLock(var1, var3, var5);
    }

    @Override
    public void implCloseChannel() throws IOException {
        this.file.close();
    }

    @Override
    public long position() throws IOException {
        return this.file.getFilePointer();
    }

    @Override
    public long size() throws IOException {
        return this.file.length();
    }

    @Override
    public int read(ByteBuffer var1) throws IOException {
        int var2 = this.file.read(var1.array(), var1.arrayOffset() + var1.position(), var1.remaining());
        if (var2 > 0) {
            var1.position(var1.position() + var2);
        }
        return var2;
    }

    @Override
    public FileChannel position(long var1) throws IOException {
        this.file.seek(var1);
        return this;
    }

    @Override
    public int write(ByteBuffer var1) throws IOException {
        int var2 = var1.remaining();
        this.file.write(var1.array(), var1.arrayOffset() + var1.position(), var2);
        var1.position(var1.position() + var2);
        return var2;
    }

    public String toString() {
        return this.name;
    }
}

