/*
 * Decompiled with CFR 0.152.
 */
package org.dizitart.no2.mvstore;

import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.dizitart.no2.common.RecordStream;
import org.dizitart.no2.common.tuples.Pair;
import org.dizitart.no2.common.util.ValidationUtils;
import org.dizitart.no2.mvstore.ReverseIterator;
import org.dizitart.no2.store.NitriteMap;
import org.dizitart.no2.store.NitriteStore;
import org.h2.mvstore.MVMap;
import org.h2.mvstore.MVStore;

class NitriteMVMap<Key, Value>
implements NitriteMap<Key, Value> {
    private final MVMap<Key, Value> mvMap;
    private final NitriteStore<?> nitriteStore;
    private final MVStore mvStore;
    private final AtomicBoolean droppedFlag;
    private final AtomicBoolean closedFlag;

    NitriteMVMap(MVMap<Key, Value> mvMap, NitriteStore<?> nitriteStore) {
        this.mvMap = mvMap;
        this.nitriteStore = nitriteStore;
        this.mvStore = mvMap.getStore();
        this.closedFlag = new AtomicBoolean(false);
        this.droppedFlag = new AtomicBoolean(false);
    }

    public boolean containsKey(Key key) {
        return this.mvMap.containsKey(key);
    }

    public Value get(Key key) {
        return (Value)this.mvMap.get(key);
    }

    public NitriteStore<?> getStore() {
        return this.nitriteStore;
    }

    public void clear() {
        MVStore.TxCounter txCounter = this.mvStore.registerVersionUsage();
        try {
            this.mvMap.clear();
            this.updateLastModifiedTime();
        }
        finally {
            this.mvStore.deregisterVersionUsage(txCounter);
        }
    }

    public String getName() {
        return this.mvMap.getName();
    }

    public RecordStream<Value> values() {
        return RecordStream.fromIterable((Iterable)this.mvMap.values());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Value remove(Key key) {
        MVStore.TxCounter txCounter = this.mvStore.registerVersionUsage();
        try {
            Object value = this.mvMap.remove(key);
            this.updateLastModifiedTime();
            Object object = value;
            return (Value)object;
        }
        finally {
            this.mvStore.deregisterVersionUsage(txCounter);
        }
    }

    public RecordStream<Key> keys() {
        return RecordStream.fromIterable((Iterable)this.mvMap.keySet());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(Key key, Value value) {
        ValidationUtils.notNull(value, (String)"value cannot be null");
        MVStore.TxCounter txCounter = this.mvStore.registerVersionUsage();
        try {
            this.mvMap.put(key, value);
            this.updateLastModifiedTime();
        }
        finally {
            this.mvStore.deregisterVersionUsage(txCounter);
        }
    }

    public long size() {
        return this.mvMap.sizeAsLong();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Value putIfAbsent(Key key, Value value) {
        ValidationUtils.notNull(value, (String)"value cannot be null");
        MVStore.TxCounter txCounter = this.mvStore.registerVersionUsage();
        try {
            Object v = this.mvMap.putIfAbsent(key, value);
            this.updateLastModifiedTime();
            Object object = v;
            return (Value)object;
        }
        finally {
            this.mvStore.deregisterVersionUsage(txCounter);
        }
    }

    public RecordStream<Pair<Key, Value>> entries() {
        return () -> new Iterator<Pair<Key, Value>>(){
            final Iterator entryIterator;
            {
                this.entryIterator = NitriteMVMap.this.mvMap.entrySet().iterator();
            }

            @Override
            public boolean hasNext() {
                return this.entryIterator.hasNext();
            }

            @Override
            public Pair<Key, Value> next() {
                Map.Entry entry = (Map.Entry)this.entryIterator.next();
                return new Pair(entry.getKey(), entry.getValue());
            }
        };
    }

    public RecordStream<Pair<Key, Value>> reversedEntries() {
        return () -> new ReverseIterator<Key, Value>(this.mvMap);
    }

    public Key firstKey() {
        return (Key)this.mvMap.firstKey();
    }

    public Key lastKey() {
        return (Key)this.mvMap.lastKey();
    }

    public Key higherKey(Key key) {
        return (Key)this.mvMap.higherKey(key);
    }

    public Key ceilingKey(Key key) {
        return (Key)this.mvMap.ceilingKey(key);
    }

    public Key lowerKey(Key key) {
        return (Key)this.mvMap.lowerKey(key);
    }

    public Key floorKey(Key key) {
        return (Key)this.mvMap.floorKey(key);
    }

    public boolean isEmpty() {
        return this.mvMap.isEmpty();
    }

    public void drop() {
        if (!this.droppedFlag.get()) {
            this.droppedFlag.compareAndSet(false, true);
            this.closedFlag.compareAndSet(false, true);
            MVStore.TxCounter txCounter = this.mvStore.registerVersionUsage();
            try {
                this.nitriteStore.closeMap(this.getName());
                this.nitriteStore.removeMap(this.getName());
            }
            finally {
                this.mvStore.deregisterVersionUsage(txCounter);
            }
        }
    }

    public boolean isDropped() {
        return this.droppedFlag.get();
    }

    public void close() {
        if (!this.closedFlag.get() && !this.droppedFlag.get()) {
            this.closedFlag.compareAndSet(false, true);
            this.nitriteStore.closeMap(this.getName());
        }
    }

    public boolean isClosed() {
        return this.closedFlag.get();
    }
}

