/*
 * Decompiled with CFR 0.152.
 */
package org.dizitart.no2.common.mapper;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.dizitart.no2.NitriteConfig;
import org.dizitart.no2.collection.Document;
import org.dizitart.no2.common.mapper.NitriteMapper;
import org.dizitart.no2.common.mapper.modules.NitriteIdModule;
import org.dizitart.no2.common.util.ValidationUtils;
import org.dizitart.no2.exceptions.ObjectMappingException;

public class JacksonMapper
implements NitriteMapper {
    private ObjectMapper objectMapper;

    protected ObjectMapper getObjectMapper() {
        if (this.objectMapper == null) {
            this.objectMapper = new ObjectMapper();
            this.objectMapper.setVisibility(this.objectMapper.getSerializationConfig().getDefaultVisibilityChecker().withFieldVisibility(JsonAutoDetect.Visibility.ANY).withGetterVisibility(JsonAutoDetect.Visibility.NONE).withIsGetterVisibility(JsonAutoDetect.Visibility.NONE));
            this.objectMapper.configure(JsonParser.Feature.ALLOW_UNQUOTED_FIELD_NAMES, true);
            this.objectMapper.configure(JsonParser.Feature.ALLOW_SINGLE_QUOTES, true);
            this.objectMapper.configure(JsonParser.Feature.ALLOW_COMMENTS, true);
            this.objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
            this.objectMapper.registerModule((Module)new NitriteIdModule());
        }
        return this.objectMapper;
    }

    public void registerJacksonModule(Module module) {
        ValidationUtils.notNull((Object)module, (String)"module cannot be null");
        this.getObjectMapper().registerModule(module);
    }

    public <Source, Target> Object tryConvert(Source source, Class<Target> type) {
        if (source == null) {
            return null;
        }
        try {
            JsonNode node = (JsonNode)this.getObjectMapper().convertValue(source, JsonNode.class);
            if (node == null) {
                return null;
            }
            if (node.isValueNode()) {
                return this.getNodeValue(node);
            }
            if (Document.class.isAssignableFrom(type)) {
                return this.convertToDocument(source);
            }
            if (source instanceof Document) {
                return this.convertFromDocument((Document)source, type);
            }
        }
        catch (Exception e) {
            throw new ObjectMappingException("Failed to convert object of type " + source.getClass() + " to type " + type, (Throwable)e);
        }
        throw new ObjectMappingException("Can't convert object to type " + type + ", try registering a jackson Module for it.");
    }

    public void initialize(NitriteConfig nitriteConfig) {
    }

    protected <Target> Target convertFromDocument(Document source, Class<Target> type) {
        try {
            return (Target)this.getObjectMapper().convertValue((Object)source, type);
        }
        catch (IllegalArgumentException iae) {
            JsonMappingException jme;
            if (iae.getCause() instanceof JsonMappingException && (jme = (JsonMappingException)iae.getCause()).getMessage().contains("Cannot construct instance")) {
                throw new ObjectMappingException(jme.getMessage());
            }
            throw iae;
        }
    }

    protected <Source> Document convertToDocument(Source source) {
        JsonNode node = (JsonNode)this.getObjectMapper().convertValue(source, JsonNode.class);
        return this.readDocument(node);
    }

    private <T> T getNodeValue(JsonNode node) {
        switch (node.getNodeType()) {
            case NUMBER: {
                return (T)node.numberValue();
            }
            case STRING: {
                return (T)node.textValue();
            }
            case BOOLEAN: {
                return (T)Boolean.valueOf(node.booleanValue());
            }
        }
        return null;
    }

    private Document readDocument(JsonNode node) {
        LinkedHashMap<String, Object> objectMap = new LinkedHashMap<String, Object>();
        Iterator fields = node.fields();
        while (fields.hasNext()) {
            Map.Entry entry = (Map.Entry)fields.next();
            String name = (String)entry.getKey();
            JsonNode value = (JsonNode)entry.getValue();
            Object object = this.readObject(value);
            objectMap.put(name, object);
        }
        return Document.createDocument(objectMap);
    }

    private Object readObject(JsonNode node) {
        if (node == null) {
            return null;
        }
        try {
            switch (node.getNodeType()) {
                case ARRAY: {
                    return this.readArray(node);
                }
                case BINARY: {
                    return node.binaryValue();
                }
                case BOOLEAN: {
                    return node.booleanValue();
                }
                case MISSING: 
                case NULL: {
                    return null;
                }
                case NUMBER: {
                    return node.numberValue();
                }
                case OBJECT: 
                case POJO: {
                    return this.readDocument(node);
                }
                case STRING: {
                    return node.textValue();
                }
            }
        }
        catch (IOException e) {
            return null;
        }
        return null;
    }

    private List readArray(JsonNode array) {
        if (array.isArray()) {
            ArrayList<Object> list = new ArrayList<Object>();
            Iterator iterator = array.elements();
            while (iterator.hasNext()) {
                Object element = iterator.next();
                if (element instanceof JsonNode) {
                    list.add(this.readObject((JsonNode)element));
                    continue;
                }
                list.add(element);
            }
            return list;
        }
        return null;
    }
}

