/*
 * Decompiled with CFR 0.152.
 */
package org.dhatim.fastexcel;

import java.io.IOException;
import org.dhatim.fastexcel.Range;
import org.dhatim.fastexcel.Writer;

public class Table {
    int index;
    private String name;
    private String displayName;
    private boolean totalsRowShown = false;
    private Range range;
    private String[] headers;
    private final TableStyleInfo styleInfo = new TableStyleInfo(this);

    Table(int index, Range range, String[] headers) {
        int count = range.getRight() - range.getLeft() + 1;
        if (headers.length != count) {
            throw new IllegalStateException("Header length no match the count of columns,table index:" + index);
        }
        for (int i = 0; i < count; ++i) {
            range.getWorksheet().value(range.getTop(), range.getLeft() + i, headers[i]);
        }
        this.index = index;
        this.range = range;
        this.headers = headers;
    }

    public Table setName(String name) {
        this.name = name;
        return this;
    }

    public Table setDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    public Table setTotalsRowShown(boolean totalsRowShown) {
        this.totalsRowShown = totalsRowShown;
        return this;
    }

    public TableStyleInfo styleInfo() {
        return this.styleInfo;
    }

    void write(Writer w) throws IOException {
        w.append("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>");
        w.append("<table xmlns=\"http://schemas.openxmlformats.org/spreadsheetml/2006/main\" ");
        w.append("id=\"" + this.index + "\" ");
        w.append("name=\"" + (this.name == null || "".equals(this.name) ? "Table" + this.index : this.name) + "\" ");
        w.append("displayName=\"" + (this.displayName == null || "".equals(this.displayName) ? "Table" + this.index : this.displayName) + "\" ");
        w.append("ref=\"" + this.range.toString() + "\" ");
        w.append("totalsRowShown=\"" + (this.totalsRowShown ? 1 : 0) + "\">");
        w.append("<autoFilter ref=\"" + this.range.toString() + "\"/>");
        int count = this.range.getRight() - this.range.getLeft() + 1;
        w.append("<tableColumns count=\"" + count + "\">");
        for (int i = 0; i < count; ++i) {
            w.append("<tableColumn id=\"" + (i + 1) + "\" name=\"" + this.headers[i] + "\"/>");
        }
        w.append("</tableColumns>");
        this.styleInfo.write(w);
    }

    public class TableStyleInfo {
        private final Table table;
        private String name;
        private boolean showFirstColumn = false;
        private boolean showLastColumn = false;
        private boolean showRowStripes = true;
        private boolean showColumnStripes = false;

        TableStyleInfo(Table table) {
            this.table = table;
        }

        public TableStyleInfo setStyleName(String name) {
            this.name = name;
            return this;
        }

        public TableStyleInfo setShowFirstColumn(boolean showFirstColumn) {
            this.showFirstColumn = showFirstColumn;
            return this;
        }

        public TableStyleInfo setShowLastColumn(boolean showLastColumn) {
            this.showLastColumn = showLastColumn;
            return this;
        }

        public TableStyleInfo setShowRowStripes(boolean showRowStripes) {
            this.showRowStripes = showRowStripes;
            return this;
        }

        public TableStyleInfo setShowColumnStripes(boolean showColumnStripes) {
            this.showColumnStripes = showColumnStripes;
            return this;
        }

        public void write(Writer w) throws IOException {
            w.append("<tableStyleInfo name=\"" + (this.name == null || "".equals(this.name) ? "TableStyleMedium2" : ((Table)Table.this).styleInfo.name) + "\" ");
            w.append("showFirstColumn=\"" + (this.showFirstColumn ? 1 : 0) + "\" ");
            w.append("showLastColumn=\"" + (this.showLastColumn ? 1 : 0) + "\" ");
            w.append("showRowStripes=\"" + (this.showRowStripes ? 1 : 0) + "\" ");
            w.append("showColumnStripes=\"" + (this.showColumnStripes ? 1 : 0) + "\"/>");
            w.append("</table>");
        }
    }
}

